/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.internal;

import java.io.IOException;
import java.util.Map;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.core.MultivaluedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=5000)
public class LogHeadersFilter
implements ClientResponseFilter,
ClientRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(LogHeadersFilter.class);

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Received '{}' response for '{}' request to '{}'", new Object[]{responseContext.getStatus(), requestContext.getMethod(), requestContext.getUri()});
        MultivaluedMap headers = responseContext.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            LOG.debug("Received header '{}' with value '{}'", entry.getKey(), entry.getValue());
        }
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        LOG.debug("Sending '{}' request to '{}'", (Object)requestContext.getMethod(), (Object)requestContext.getUri());
        MultivaluedMap headers = requestContext.getStringHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            LOG.debug("Sending header '{}' with value '{}'", entry.getKey(), entry.getValue());
        }
    }
}

