/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Options {

    private static final Logger LOG = LoggerFactory.getLogger(Options.class);
    private static volatile boolean SHOULD_AUTO_CLOSE_RESPONSE_INPUTSTREAM = true;
    private static final String OCI_REALM_SPECIFIC_SERVICE_ENDPOINT_TEMPLATE_ENABLED_ENV_VAR = "OCI_REALM_SPECIFIC_SERVICE_ENDPOINT_TEMPLATE_ENABLED";
    private static final String JAVASDK_TOKEN_REFRESH_ENABLED_SYSTEM_PROPERTY = "oci.javasdk.token.refresh.enabled";
    private static volatile boolean TOKEN_REFRESH_RETRY_ENABLED;
    private static volatile Boolean USE_OF_REALM_SPECIFIC_ENDPOINT_TEMPLATE_ENABLED_PROGRAMMATICALLY;

    public static void shouldAutoCloseResponseInputStream(boolean shouldAutoClose) {
        LOG.info("Setting auto-close of response input stream to {}", (Object)shouldAutoClose);
        SHOULD_AUTO_CLOSE_RESPONSE_INPUTSTREAM = shouldAutoClose;
    }

    public static boolean getShouldAutoCloseResponseInputStream() {
        return SHOULD_AUTO_CLOSE_RESPONSE_INPUTSTREAM;
    }

    public static boolean getUseOfRealmSpecificEndpointTemplateByDefault() {
        if (USE_OF_REALM_SPECIFIC_ENDPOINT_TEMPLATE_ENABLED_PROGRAMMATICALLY != null) {
            return USE_OF_REALM_SPECIFIC_ENDPOINT_TEMPLATE_ENABLED_PROGRAMMATICALLY;
        }
        String useOfRealmSpecificEndpointTemplateEnabledEnvVar = System.getenv(OCI_REALM_SPECIFIC_SERVICE_ENDPOINT_TEMPLATE_ENABLED_ENV_VAR);
        return useOfRealmSpecificEndpointTemplateEnabledEnvVar != null && useOfRealmSpecificEndpointTemplateEnabledEnvVar.equalsIgnoreCase("true");
    }

    public static Boolean getUseOfRealmSpecificEndpointTemplateEnabledProgrammatically() {
        return USE_OF_REALM_SPECIFIC_ENDPOINT_TEMPLATE_ENABLED_PROGRAMMATICALLY;
    }

    public static void setUseOfRealmSpecificEndpointTemplateEnabledProgrammatically(Boolean useOfRealmSpecificEndpointTemplateEnabledProgrammatically) {
        USE_OF_REALM_SPECIFIC_ENDPOINT_TEMPLATE_ENABLED_PROGRAMMATICALLY = useOfRealmSpecificEndpointTemplateEnabledProgrammatically;
    }

    private static void initializeTokenRefreshRetryEnabled() {
        TOKEN_REFRESH_RETRY_ENABLED = Boolean.parseBoolean(System.getProperty(JAVASDK_TOKEN_REFRESH_ENABLED_SYSTEM_PROPERTY, "true"));
        LOG.debug("Setting token refresh retry to {}", (Object)TOKEN_REFRESH_RETRY_ENABLED);
    }

    public static boolean isTokenRefreshRetrierEnabled() {
        return TOKEN_REFRESH_RETRY_ENABLED;
    }

    static {
        Options.initializeTokenRefreshRetryEnabled();
        USE_OF_REALM_SPECIFIC_ENDPOINT_TEMPLATE_ENABLED_PROGRAMMATICALLY = null;
    }
}

