/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client;

import com.oracle.bmc.http.client.HttpProviderCapability;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.Method;
import java.io.Closeable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface HttpClient
extends Closeable {
    public HttpRequest createRequest(Method var1);

    default public HttpRequest createRequest(Method method, Map<String, Object> requiredParametersMap, Map<String, Boolean> optionsMap) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.warn("HTTP client '{}' does not support options in endpoints, not replacing parameters or options.", (Object)this.getClass().getName());
        return this.createRequest(method);
    }

    @Override
    public void close();

    public boolean isProcessingException(Exception var1);

    @Deprecated
    default public void updateEndpoint(String baseTarget) {
        Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.warn("The HttpClient.updateEndpoint(String) method is deprecated and should not be called");
    }

    default public boolean hasCapability(HttpProviderCapability capability) {
        return false;
    }
}

