/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3.internal;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdleConnectionMonitor
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(IdleConnectionMonitor.class);
    private final HttpClientConnectionManager connMgr;
    private final int waitTimeInSeconds;
    private final int idleTimeoutInSeconds;
    private volatile boolean shutdown;

    public IdleConnectionMonitor(HttpClientConnectionManager connMgr, int waitTimeInSeconds, int idleTimeout) {
        Objects.requireNonNull(connMgr, "ConnectionManager cannot be null");
        this.connMgr = connMgr;
        this.waitTimeInSeconds = waitTimeInSeconds;
        this.idleTimeoutInSeconds = idleTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!this.shutdown) {
                IdleConnectionMonitor idleConnectionMonitor = this;
                synchronized (idleConnectionMonitor) {
                    this.wait(this.waitTimeInSeconds * 1000);
                    this.connMgr.closeExpiredConnections();
                    this.connMgr.closeIdleConnections((long)this.idleTimeoutInSeconds, TimeUnit.SECONDS);
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            LOG.info("IdleConnectionMonitorThread was interrupted, terminating", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        IdleConnectionMonitor idleConnectionMonitor = this;
        synchronized (idleConnectionMonitor) {
            this.notifyAll();
        }
    }

    public boolean isIdleMonitorThreadShutdown() {
        return this.shutdown;
    }
}

