/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.oracle.bmc.http.client.HttpRequest;
import com.oracle.bmc.http.client.HttpResponse;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.Serialization;
import com.oracle.bmc.http.client.io.DuplicatableInputStream;
import com.oracle.bmc.http.client.jersey3.Jersey3HttpClient;
import com.oracle.bmc.http.client.jersey3.Jersey3HttpResponse;
import com.oracle.bmc.http.client.jersey3.internal.ApacheDuplicatableInputStreamEntity;
import com.oracle.bmc.http.client.jersey3.internal.ApacheInputStreamEntity;
import jakarta.ws.rs.client.CompletionStageRxInvoker;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Variant;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Jersey3HttpRequest
implements HttpRequest {
    static final boolean isExtraStreamLogsEnabled = Jersey3HttpRequest.isExtraStreamLogsEnabledViaSystemProperty();
    private static final Logger LOG = LoggerFactory.getLogger(Jersey3HttpRequest.class);
    private final Jersey3HttpClient client;
    private final Method method;
    private Object processedBody;
    private MediaType requestBodyType;
    private Locale requestBodyLanguage;
    private String requestBodyEncoding;
    private WebTarget webTarget;
    private final MultivaluedMap<String, String> headers;
    private final Map<String, Object> attributes;

    private static boolean isExtraStreamLogsEnabledViaSystemProperty() {
        String trimmedValue;
        String streamLogsEnabledString = System.getProperty("oci.javasdk.extra.stream.logs.enabled");
        return streamLogsEnabledString == null || streamLogsEnabledString.isEmpty() || !"false".equalsIgnoreCase(trimmedValue = streamLogsEnabledString.trim());
    }

    Jersey3HttpRequest(Jersey3HttpClient client, Method method, WebTarget webTarget) {
        this.client = client;
        this.method = method;
        this.webTarget = webTarget;
        this.attributes = new HashMap<String, Object>();
        this.headers = new MultivaluedHashMap();
    }

    private Jersey3HttpRequest(Jersey3HttpRequest from) {
        this.client = from.client;
        this.method = from.method;
        this.processedBody = from.processedBody;
        this.requestBodyType = from.requestBodyType;
        this.requestBodyLanguage = from.requestBodyLanguage;
        this.requestBodyEncoding = from.requestBodyEncoding;
        this.webTarget = from.webTarget;
        this.headers = new MultivaluedHashMap(from.headers);
        this.attributes = new HashMap<String, Object>(from.attributes);
    }

    public Method method() {
        return this.method;
    }

    private void logAvailable(InputStream body) {
        if (isExtraStreamLogsEnabled) {
            try {
                int bytesAvailable = body.available();
                if (bytesAvailable == 0) {
                    LOG.warn("Stream size to upload is 0 bytes, this could potentially lead to data corruption. If this is not intended, please make sure all the OCI SDK dependencies point to the same version");
                }
            }
            catch (IOException e) {
                LOG.warn("Error calling available on the stream to get the available number of bytes");
            }
        }
    }

    public HttpRequest body(Object body) {
        if (body instanceof String) {
            this.processedBody = body;
        } else if (body instanceof InputStream) {
            this.logAvailable((InputStream)body);
            this.processedBody = body;
        } else if (body == null) {
            this.processedBody = "";
        } else {
            try {
                this.processedBody = Serialization.getObjectMapper().writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                throw new IllegalArgumentException("Unable to process JSON body", e);
            }
        }
        return this;
    }

    public HttpRequest body(InputStream body, long contentLength) {
        this.logAvailable(body);
        this.processedBody = this.client.isApacheNonBufferingClient && contentLength > 0L ? (body instanceof DuplicatableInputStream ? new ApacheDuplicatableInputStreamEntity((DuplicatableInputStream)body, (Long)contentLength) : new ApacheInputStreamEntity(body, contentLength)) : body;
        return this;
    }

    public Object body() {
        return this.processedBody;
    }

    public HttpRequest appendPathPart(String encodedPathPart) {
        this.webTarget = this.webTarget.path(encodedPathPart);
        return this;
    }

    public HttpRequest query(String name, String value) {
        this.webTarget = this.webTarget.queryParam(name, new Object[]{value});
        return this;
    }

    public URI uri() {
        return this.webTarget.getUri();
    }

    public HttpRequest header(String name, String value) {
        this.headers.add((Object)name, (Object)value);
        if (name.equalsIgnoreCase("Content-Type")) {
            this.requestBodyType = MediaType.valueOf((String)value);
        }
        if (name.equalsIgnoreCase("Content-Language")) {
            this.requestBodyLanguage = Locale.forLanguageTag(value);
        }
        if (name.equalsIgnoreCase("Content-Encoding")) {
            this.requestBodyEncoding = value;
        }
        return this;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public Object attribute(String name) {
        return this.attributes.get(name);
    }

    public HttpRequest removeAttribute(String name) {
        this.attributes.remove(name);
        return this;
    }

    public HttpRequest attribute(String name, Object value) {
        this.attributes.put(name, value);
        return this;
    }

    public HttpRequest offloadExecutor(Executor executor) {
        return this;
    }

    public HttpRequest copy() {
        return new Jersey3HttpRequest(this);
    }

    public void discard() {
    }

    public CompletionStage<HttpResponse> execute() {
        CompletionStage stage;
        for (RequestInterceptor interceptor : this.client.requestInterceptors) {
            interceptor.intercept((HttpRequest)this);
        }
        CompletionStageRxInvoker invoker = this.webTarget.request().headers((MultivaluedMap)new MultivaluedHashMap(this.headers)).rx();
        if (this.processedBody == null) {
            stage = invoker.method(this.method.name());
        } else {
            Variant variant = new Variant(this.requestBodyType, this.requestBodyLanguage, this.requestBodyEncoding);
            stage = invoker.method(this.method.name(), Entity.entity((Object)this.processedBody, (Variant)variant));
        }
        return stage.thenApply(Jersey3HttpResponse::new);
    }
}

