/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.http.client.jersey3;

import com.oracle.bmc.http.client.ClientProperty;
import com.oracle.bmc.http.client.HttpClient;
import com.oracle.bmc.http.client.HttpClientBuilder;
import com.oracle.bmc.http.client.KeyStoreWithPassword;
import com.oracle.bmc.http.client.ProxyConfiguration;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.client.Serialization;
import com.oracle.bmc.http.client.StandardClientProperties;
import com.oracle.bmc.http.client.jersey3.ApacheClientProperties;
import com.oracle.bmc.http.client.jersey3.Jersey3ClientProperties;
import com.oracle.bmc.http.client.jersey3.Jersey3ClientProperty;
import com.oracle.bmc.http.client.jersey3.Jersey3HttpClient;
import com.oracle.bmc.http.client.jersey3.Jersey3HttpProvider;
import com.oracle.bmc.http.client.jersey3.internal.DaemonClientAsyncExecutorProvider;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Configuration;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.NoConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.RequestContent;
import org.glassfish.jersey.apache.connector.ApacheConnectionClosingStrategy;
import org.glassfish.jersey.apache.connector.ApacheConnectorProvider;
import org.glassfish.jersey.apache.connector.ApacheHttpClientBuilderConfigurator;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.client.HttpUrlConnectorProvider;
import org.glassfish.jersey.client.RequestEntityProcessing;
import org.glassfish.jersey.client.spi.ConnectorProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.JacksonJsonProvider;
import org.glassfish.jersey.spi.ExecutorServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Jersey3HttpClientBuilder
implements HttpClientBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(Jersey3HttpClientBuilder.class);
    public static ConnectionReuseStrategy DEFAULT_CONNECTION_REUSE_STRATEGY = new NoConnectionReuseStrategy();
    public static HttpRequestRetryHandler DEFAULT_REQUEST_RETRY_HANDLER = new DefaultHttpRequestRetryHandler(0, false);
    public static final JacksonJsonProvider JACKSON_JSON_PROVIDER = new JacksonJaxbJsonProvider(Serialization.getObjectMapper(), JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);
    private final Collection<PrioritizedValue<RequestInterceptor>> requestInterceptors = new ArrayList<PrioritizedValue<RequestInterceptor>>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private URI baseUri;
    private boolean isApacheNonBufferingClient = false;
    private KeyStoreWithPassword keyStore;
    private KeyStore trustStore;
    private HostnameVerifier hostnameVerifier;
    private SSLContext sslContext;
    private boolean useApacheConnector = true;
    private ExecutorServiceProvider executorServiceProvider = null;
    private boolean useJerseyDefaultExecutorServiceProvider = false;

    Jersey3HttpClientBuilder() {
        this.properties.put("jersey.config.client.request.entity.processing", RequestEntityProcessing.BUFFERED);
        if (Jersey3HttpProvider.isApacheDependencyPresent && this.useApacheConnector) {
            this.properties.put("jersey.config.apache.client.requestConfig", RequestConfig.custom().setContentCompressionEnabled(false).setExpectContinueEnabled(false).setConnectionRequestTimeout(60000).build());
            this.properties.put("jersey.config.apache.client.connectionClosingStrategy", new ApacheConnectionClosingStrategy.ImmediateClosingStrategy());
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
            cm.setMaxTotal(50);
            cm.setDefaultMaxPerRoute(50);
            this.properties.put("jersey.config.apache.client.connectionManager", cm);
            this.property(ApacheClientProperties.CONNECTION_MANAGER_SHARED, false);
            this.property(ApacheClientProperties.RETRY_HANDLER, DEFAULT_REQUEST_RETRY_HANDLER);
            this.property(ApacheClientProperties.REUSE_STRATEGY, DEFAULT_CONNECTION_REUSE_STRATEGY);
        }
    }

    public HttpClientBuilder baseUri(URI uri) {
        this.baseUri = uri;
        return this;
    }

    public <T> HttpClientBuilder property(ClientProperty<T> key, T value) {
        if (key == StandardClientProperties.ASYNC_POOL_SIZE) {
            this.properties.put("jersey.config.client.async.threadPoolSize", value);
        } else if (key == StandardClientProperties.READ_TIMEOUT) {
            this.properties.put("jersey.config.client.readTimeout", (int)((Duration)value).toMillis());
        } else if (key == StandardClientProperties.CONNECT_TIMEOUT) {
            this.properties.put("jersey.config.client.connectTimeout", (int)((Duration)value).toMillis());
        } else if (key == StandardClientProperties.KEY_STORE) {
            this.keyStore = (KeyStoreWithPassword)value;
        } else if (key == StandardClientProperties.TRUST_STORE) {
            this.trustStore = (KeyStore)value;
        } else if (key == StandardClientProperties.HOSTNAME_VERIFIER) {
            this.hostnameVerifier = (HostnameVerifier)value;
        } else if (key == StandardClientProperties.SSL_CONTEXT) {
            this.sslContext = (SSLContext)value;
        } else if (key == StandardClientProperties.BUFFER_REQUEST) {
            if (((Boolean)value).booleanValue()) {
                this.properties.put("jersey.config.client.request.entity.processing", RequestEntityProcessing.BUFFERED);
            } else if (Jersey3HttpProvider.isApacheDependencyPresent) {
                this.isApacheNonBufferingClient = true;
            } else {
                this.properties.put("jersey.config.client.request.entity.processing", RequestEntityProcessing.CHUNKED);
            }
        } else if (key == StandardClientProperties.PROXY) {
            String scheme;
            ProxyConfiguration proxy = (ProxyConfiguration)value;
            switch (proxy.getProxy().type()) {
                case HTTP: {
                    scheme = "http";
                    break;
                }
                case SOCKS: {
                    scheme = "socks";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported proxy type: " + (Object)((Object)proxy.getProxy().type()));
                }
            }
            InetSocketAddress address = (InetSocketAddress)proxy.getProxy().address();
            try {
                this.properties.put("jersey.config.client.proxy.uri", new URI(scheme, address.getHostString(), Integer.toString(address.getPort()), null));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
            if (proxy.getUsername() != null) {
                this.properties.put("jersey.config.client.proxy.username", proxy.getUsername());
            }
            if (proxy.getPassword() != null) {
                this.properties.put("jersey.config.client.proxy.password", proxy.getPassword());
            }
        } else if (key == Jersey3ClientProperties.USE_APACHE_CONNECTOR) {
            this.useApacheConnector = (Boolean)value;
        } else if (key == Jersey3ClientProperties.USE_JERSEY_DEFAULT_EXECUTOR_SERVICE_PROVIDER) {
            this.useJerseyDefaultExecutorServiceProvider = (Boolean)value == Boolean.TRUE;
        } else if (key == Jersey3ClientProperties.EXECUTOR_SERVICE_PROVIDER) {
            this.executorServiceProvider = (ExecutorServiceProvider)value;
        } else if (key instanceof Jersey3ClientProperty) {
            this.properties.put(((Jersey3ClientProperty)key).jerseyProperty, value);
        } else {
            throw new IllegalArgumentException("Unknown or unsupported HTTP client property " + key);
        }
        return this;
    }

    public HttpClientBuilder registerRequestInterceptor(int priority, RequestInterceptor interceptor) {
        this.requestInterceptors.add(new PrioritizedValue<RequestInterceptor>(priority, interceptor));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public HttpClient build() {
        ClientBuilder clientBuilder = ClientBuilder.newBuilder();
        ClientConfig clientConfig = new ClientConfig();
        if (Jersey3HttpProvider.isApacheDependencyPresent) {
            LOG.info("Setting connector provider to ApacheConnectorProvider");
            clientConfig.connectorProvider((ConnectorProvider)new ApacheConnectorProvider());
            clientConfig.register((Object)new ApacheHttpClientBuilderConfigurator(){

                public org.apache.http.impl.client.HttpClientBuilder configure(org.apache.http.impl.client.HttpClientBuilder httpClientBuilder) {
                    return httpClientBuilder.addInterceptorLast((HttpRequestInterceptor)new RequestContent(true));
                }
            });
        } else {
            LOG.info("Setting connector provider to HttpUrlConnectorProvider");
            HttpUrlConnectorProvider provider = new HttpUrlConnectorProvider().useSetMethodWorkaround();
            clientConfig.connectorProvider((ConnectorProvider)provider);
        }
        clientBuilder.withConfig((Configuration)clientConfig);
        clientBuilder.register((Object)JACKSON_JSON_PROVIDER);
        for (Map.Entry entry : this.properties.entrySet()) {
            clientBuilder.property((String)entry.getKey(), entry.getValue());
        }
        clientBuilder.property("jersey.config.jsonFeature", (Object)"JacksonFeature");
        if (this.keyStore != null) {
            clientBuilder.keyStore(this.keyStore.getKeyStore(), this.keyStore.getPassword());
        }
        if (this.sslContext == null) {
            if (this.trustStore != null) {
                clientBuilder.trustStore(this.trustStore);
            }
            if (this.hostnameVerifier != null) {
                clientBuilder.hostnameVerifier(this.hostnameVerifier);
            }
        } else {
            if (this.trustStore != null || this.hostnameVerifier != null) {
                throw new IllegalStateException("Cannot set trust store or hostname verifier when SSL context is also set");
            }
            clientBuilder.sslContext(this.sslContext);
        }
        Client client = clientBuilder.build();
        if (this.executorServiceProvider != null) {
            client.register((Object)this.executorServiceProvider);
        } else if (!this.useJerseyDefaultExecutorServiceProvider) {
            client.register(DaemonClientAsyncExecutorProvider.class);
        }
        if (LOG.isTraceEnabled()) {
            void var4_7;
            Object var4_5 = null;
            if (client.getConfiguration() != null && client.getConfiguration().getProperties() != null) {
                String string = client.getConfiguration().getProperties().entrySet().stream().sorted(Comparator.comparing(e -> (String)e.getKey())).map(e -> "['" + (String)e.getKey() + "':'" + e.getValue() + "']").collect(Collectors.joining(", "));
            }
            LOG.trace("Creating client '{}' with 'isApacheNonBufferingClient'='{}' and properties: {}", new Object[]{client.getClass().getName(), this.isApacheNonBufferingClient, var4_7});
        }
        return new Jersey3HttpClient(client, client.target(this.baseUri), this.requestInterceptors.stream().sorted(Comparator.comparingInt(p -> p.priority)).map(p -> (RequestInterceptor)p.value).collect(Collectors.toList()), this.isApacheNonBufferingClient);
    }

    private static class PrioritizedValue<T> {
        final int priority;
        final T value;

        PrioritizedValue(int priority, T value) {
            this.priority = priority;
            this.value = value;
        }
    }
}

