/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.responses;

import com.oracle.bmc.cloudmigrations.model.MigrationPlan;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateMigrationPlanResponse
extends BmcResponse {
    private String etag;
    private String opcRequestId;
    private String opcWorkRequestId;
    private String location;
    private String contentLocation;
    private MigrationPlan migrationPlan;

    public String getEtag() {
        return this.etag;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public MigrationPlan getMigrationPlan() {
        return this.migrationPlan;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "opcRequestId", "opcWorkRequestId", "location", "contentLocation", "migrationPlan"})
    private CreateMigrationPlanResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String opcRequestId, String opcWorkRequestId, String location, String contentLocation, MigrationPlan migrationPlan) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.opcRequestId = opcRequestId;
        this.opcWorkRequestId = opcWorkRequestId;
        this.location = location;
        this.contentLocation = contentLocation;
        this.migrationPlan = migrationPlan;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(",migrationPlan=").append(String.valueOf((Object)this.migrationPlan));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMigrationPlanResponse)) {
            return false;
        }
        CreateMigrationPlanResponse other = (CreateMigrationPlanResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.location, other.location) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals((Object)this.migrationPlan, (Object)other.migrationPlan);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.migrationPlan == null ? 43 : this.migrationPlan.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateMigrationPlanResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String opcRequestId;
        private String opcWorkRequestId;
        private String location;
        private String contentLocation;
        private MigrationPlan migrationPlan;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder migrationPlan(MigrationPlan migrationPlan) {
            this.migrationPlan = migrationPlan;
            return this;
        }

        public Builder copy(CreateMigrationPlanResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.opcRequestId(o.getOpcRequestId());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.location(o.getLocation());
            this.contentLocation(o.getContentLocation());
            this.migrationPlan(o.getMigrationPlan());
            return this;
        }

        public CreateMigrationPlanResponse build() {
            return new CreateMigrationPlanResponse(this.__httpStatusCode__, this.headers, this.etag, this.opcRequestId, this.opcWorkRequestId, this.location, this.contentLocation, this.migrationPlan);
        }
    }
}

