/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudmigrations.model.SortOrder;
import com.oracle.bmc.cloudmigrations.model.TargetAsset;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListTargetAssetsRequest
extends BmcRequest<Void> {
    private String migrationPlanId;
    private String displayName;
    private String targetAssetId;
    private Integer limit;
    private String page;
    private TargetAsset.LifecycleState lifecycleState;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getMigrationPlanId() {
        return this.migrationPlanId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getTargetAssetId() {
        return this.targetAssetId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public TargetAsset.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().migrationPlanId(this.migrationPlanId).displayName(this.displayName).targetAssetId(this.targetAssetId).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationPlanId=").append(String.valueOf(this.migrationPlanId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",targetAssetId=").append(String.valueOf(this.targetAssetId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListTargetAssetsRequest)) {
            return false;
        }
        ListTargetAssetsRequest other = (ListTargetAssetsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationPlanId, other.migrationPlanId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.targetAssetId, other.targetAssetId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationPlanId == null ? 43 : this.migrationPlanId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.targetAssetId == null ? 43 : this.targetAssetId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListTargetAssetsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationPlanId = null;
        private String displayName = null;
        private String targetAssetId = null;
        private Integer limit = null;
        private String page = null;
        private TargetAsset.LifecycleState lifecycleState = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder migrationPlanId(String migrationPlanId) {
            this.migrationPlanId = migrationPlanId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder targetAssetId(String targetAssetId) {
            this.targetAssetId = targetAssetId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(TargetAsset.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListTargetAssetsRequest o) {
            this.migrationPlanId(o.getMigrationPlanId());
            this.displayName(o.getDisplayName());
            this.targetAssetId(o.getTargetAssetId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListTargetAssetsRequest build() {
            ListTargetAssetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListTargetAssetsRequest buildWithoutInvocationCallback() {
            ListTargetAssetsRequest request = new ListTargetAssetsRequest();
            request.migrationPlanId = this.migrationPlanId;
            request.displayName = this.displayName;
            request.targetAssetId = this.targetAssetId;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

