/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudmigrations.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAvailableShapesRequest
extends BmcRequest<Void> {
    private String migrationPlanId;
    private String compartmentId;
    private String dvhHostId;
    private String availabilityDomain;
    private String reservedCapacityId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;

    public String getMigrationPlanId() {
        return this.migrationPlanId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDvhHostId() {
        return this.dvhHostId;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getReservedCapacityId() {
        return this.reservedCapacityId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public Builder toBuilder() {
        return new Builder().migrationPlanId(this.migrationPlanId).compartmentId(this.compartmentId).dvhHostId(this.dvhHostId).availabilityDomain(this.availabilityDomain).reservedCapacityId(this.reservedCapacityId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationPlanId=").append(String.valueOf(this.migrationPlanId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",dvhHostId=").append(String.valueOf(this.dvhHostId));
        sb.append(",availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(",reservedCapacityId=").append(String.valueOf(this.reservedCapacityId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAvailableShapesRequest)) {
            return false;
        }
        ListAvailableShapesRequest other = (ListAvailableShapesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationPlanId, other.migrationPlanId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dvhHostId, other.dvhHostId) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.reservedCapacityId, other.reservedCapacityId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationPlanId == null ? 43 : this.migrationPlanId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dvhHostId == null ? 43 : this.dvhHostId.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.reservedCapacityId == null ? 43 : this.reservedCapacityId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAvailableShapesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationPlanId = null;
        private String compartmentId = null;
        private String dvhHostId = null;
        private String availabilityDomain = null;
        private String reservedCapacityId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;

        public Builder migrationPlanId(String migrationPlanId) {
            this.migrationPlanId = migrationPlanId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder dvhHostId(String dvhHostId) {
            this.dvhHostId = dvhHostId;
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            return this;
        }

        public Builder reservedCapacityId(String reservedCapacityId) {
            this.reservedCapacityId = reservedCapacityId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAvailableShapesRequest o) {
            this.migrationPlanId(o.getMigrationPlanId());
            this.compartmentId(o.getCompartmentId());
            this.dvhHostId(o.getDvhHostId());
            this.availabilityDomain(o.getAvailabilityDomain());
            this.reservedCapacityId(o.getReservedCapacityId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAvailableShapesRequest build() {
            ListAvailableShapesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAvailableShapesRequest buildWithoutInvocationCallback() {
            ListAvailableShapesRequest request = new ListAvailableShapesRequest();
            request.migrationPlanId = this.migrationPlanId;
            request.compartmentId = this.compartmentId;
            request.dvhHostId = this.dvhHostId;
            request.availabilityDomain = this.availabilityDomain;
            request.reservedCapacityId = this.reservedCapacityId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

