/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetReplicationScheduleRequest
extends BmcRequest<Void> {
    private String replicationScheduleId;
    private String opcRequestId;

    public String getReplicationScheduleId() {
        return this.replicationScheduleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().replicationScheduleId(this.replicationScheduleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",replicationScheduleId=").append(String.valueOf(this.replicationScheduleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetReplicationScheduleRequest)) {
            return false;
        }
        GetReplicationScheduleRequest other = (GetReplicationScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.replicationScheduleId, other.replicationScheduleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.replicationScheduleId == null ? 43 : this.replicationScheduleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetReplicationScheduleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String replicationScheduleId = null;
        private String opcRequestId = null;

        public Builder replicationScheduleId(String replicationScheduleId) {
            this.replicationScheduleId = replicationScheduleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetReplicationScheduleRequest o) {
            this.replicationScheduleId(o.getReplicationScheduleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetReplicationScheduleRequest build() {
            GetReplicationScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetReplicationScheduleRequest buildWithoutInvocationCallback() {
            GetReplicationScheduleRequest request = new GetReplicationScheduleRequest();
            request.replicationScheduleId = this.replicationScheduleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

