/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetReplicationProgressRequest
extends BmcRequest<Void> {
    private String migrationAssetId;
    private String opcRequestId;

    public String getMigrationAssetId() {
        return this.migrationAssetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().migrationAssetId(this.migrationAssetId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",migrationAssetId=").append(String.valueOf(this.migrationAssetId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetReplicationProgressRequest)) {
            return false;
        }
        GetReplicationProgressRequest other = (GetReplicationProgressRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.migrationAssetId, other.migrationAssetId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.migrationAssetId == null ? 43 : this.migrationAssetId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetReplicationProgressRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String migrationAssetId = null;
        private String opcRequestId = null;

        public Builder migrationAssetId(String migrationAssetId) {
            this.migrationAssetId = migrationAssetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetReplicationProgressRequest o) {
            this.migrationAssetId(o.getMigrationAssetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetReplicationProgressRequest build() {
            GetReplicationProgressRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetReplicationProgressRequest buildWithoutInvocationCallback() {
            GetReplicationProgressRequest request = new GetReplicationProgressRequest();
            request.migrationAssetId = this.migrationAssetId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

