/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.CompatibilityMessage;
import com.oracle.bmc.cloudmigrations.model.CostEstimation;
import com.oracle.bmc.cloudmigrations.model.LaunchInstanceDetails;
import com.oracle.bmc.cloudmigrations.model.MigrationAsset;
import com.oracle.bmc.cloudmigrations.model.TargetAsset;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class VmTargetAsset
extends TargetAsset {
    @JsonProperty(value="preferredShapeType")
    private final PreferredShapeType preferredShapeType;
    @JsonProperty(value="testSpec")
    private final LaunchInstanceDetails testSpec;
    @JsonProperty(value="blockVolumesPerformance")
    private final Integer blockVolumesPerformance;
    @JsonProperty(value="msLicense")
    private final String msLicense;
    @JsonProperty(value="userSpec")
    private final LaunchInstanceDetails userSpec;
    @JsonProperty(value="recommendedSpec")
    private final LaunchInstanceDetails recommendedSpec;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public VmTargetAsset(String id, String displayName, TargetAsset.LifecycleState lifecycleState, String lifecycleDetails, String migrationPlanId, String compartmentId, String createdResourceId, Boolean isExcludedFromExecution, List<CompatibilityMessage> compatibilityMessages, CostEstimation estimatedCost, Date timeCreated, Date timeUpdated, Date timeAssessed, MigrationAsset migrationAsset, PreferredShapeType preferredShapeType, LaunchInstanceDetails testSpec, Integer blockVolumesPerformance, String msLicense, LaunchInstanceDetails userSpec, LaunchInstanceDetails recommendedSpec) {
        super(id, displayName, lifecycleState, lifecycleDetails, migrationPlanId, compartmentId, createdResourceId, isExcludedFromExecution, compatibilityMessages, estimatedCost, timeCreated, timeUpdated, timeAssessed, migrationAsset);
        this.preferredShapeType = preferredShapeType;
        this.testSpec = testSpec;
        this.blockVolumesPerformance = blockVolumesPerformance;
        this.msLicense = msLicense;
        this.userSpec = userSpec;
        this.recommendedSpec = recommendedSpec;
    }

    public PreferredShapeType getPreferredShapeType() {
        return this.preferredShapeType;
    }

    public LaunchInstanceDetails getTestSpec() {
        return this.testSpec;
    }

    public Integer getBlockVolumesPerformance() {
        return this.blockVolumesPerformance;
    }

    public String getMsLicense() {
        return this.msLicense;
    }

    public LaunchInstanceDetails getUserSpec() {
        return this.userSpec;
    }

    public LaunchInstanceDetails getRecommendedSpec() {
        return this.recommendedSpec;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("VmTargetAsset(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", preferredShapeType=").append(String.valueOf((Object)this.preferredShapeType));
        sb.append(", testSpec=").append(String.valueOf((Object)this.testSpec));
        sb.append(", blockVolumesPerformance=").append(String.valueOf(this.blockVolumesPerformance));
        sb.append(", msLicense=").append(String.valueOf(this.msLicense));
        sb.append(", userSpec=").append(String.valueOf((Object)this.userSpec));
        sb.append(", recommendedSpec=").append(String.valueOf((Object)this.recommendedSpec));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VmTargetAsset)) {
            return false;
        }
        VmTargetAsset other = (VmTargetAsset)((Object)o);
        return Objects.equals((Object)this.preferredShapeType, (Object)other.preferredShapeType) && Objects.equals((Object)this.testSpec, (Object)other.testSpec) && Objects.equals(this.blockVolumesPerformance, other.blockVolumesPerformance) && Objects.equals(this.msLicense, other.msLicense) && Objects.equals((Object)this.userSpec, (Object)other.userSpec) && Objects.equals((Object)this.recommendedSpec, (Object)other.recommendedSpec) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.preferredShapeType == null ? 43 : this.preferredShapeType.hashCode());
        result = result * 59 + (this.testSpec == null ? 43 : this.testSpec.hashCode());
        result = result * 59 + (this.blockVolumesPerformance == null ? 43 : this.blockVolumesPerformance.hashCode());
        result = result * 59 + (this.msLicense == null ? 43 : this.msLicense.hashCode());
        result = result * 59 + (this.userSpec == null ? 43 : this.userSpec.hashCode());
        result = result * 59 + (this.recommendedSpec == null ? 43 : this.recommendedSpec.hashCode());
        return result;
    }

    public static enum PreferredShapeType implements BmcEnum
    {
        Vm("VM"),
        VmIntel("VM_INTEL"),
        VmIntelStandard("VM_INTEL_Standard"),
        VmIntelDensIo("VM_INTEL_DensIO"),
        VmIntelGpu("VM_INTEL_GPU"),
        VmIntelOptimized("VM_INTEL_Optimized"),
        VmAmd("VM_AMD"),
        VmAmdStandard("VM_AMD_Standard"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PreferredShapeType> map;

        private PreferredShapeType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PreferredShapeType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PreferredShapeType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PreferredShapeType.class);
            map = new HashMap<String, PreferredShapeType>();
            for (PreferredShapeType v : PreferredShapeType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private TargetAsset.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="migrationPlanId")
        private String migrationPlanId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="createdResourceId")
        private String createdResourceId;
        @JsonProperty(value="isExcludedFromExecution")
        private Boolean isExcludedFromExecution;
        @JsonProperty(value="compatibilityMessages")
        private List<CompatibilityMessage> compatibilityMessages;
        @JsonProperty(value="estimatedCost")
        private CostEstimation estimatedCost;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeAssessed")
        private Date timeAssessed;
        @JsonProperty(value="migrationAsset")
        private MigrationAsset migrationAsset;
        @JsonProperty(value="preferredShapeType")
        private PreferredShapeType preferredShapeType;
        @JsonProperty(value="testSpec")
        private LaunchInstanceDetails testSpec;
        @JsonProperty(value="blockVolumesPerformance")
        private Integer blockVolumesPerformance;
        @JsonProperty(value="msLicense")
        private String msLicense;
        @JsonProperty(value="userSpec")
        private LaunchInstanceDetails userSpec;
        @JsonProperty(value="recommendedSpec")
        private LaunchInstanceDetails recommendedSpec;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(TargetAsset.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder migrationPlanId(String migrationPlanId) {
            this.migrationPlanId = migrationPlanId;
            this.__explicitlySet__.add("migrationPlanId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder createdResourceId(String createdResourceId) {
            this.createdResourceId = createdResourceId;
            this.__explicitlySet__.add("createdResourceId");
            return this;
        }

        public Builder isExcludedFromExecution(Boolean isExcludedFromExecution) {
            this.isExcludedFromExecution = isExcludedFromExecution;
            this.__explicitlySet__.add("isExcludedFromExecution");
            return this;
        }

        public Builder compatibilityMessages(List<CompatibilityMessage> compatibilityMessages) {
            this.compatibilityMessages = compatibilityMessages;
            this.__explicitlySet__.add("compatibilityMessages");
            return this;
        }

        public Builder estimatedCost(CostEstimation estimatedCost) {
            this.estimatedCost = estimatedCost;
            this.__explicitlySet__.add("estimatedCost");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeAssessed(Date timeAssessed) {
            this.timeAssessed = timeAssessed;
            this.__explicitlySet__.add("timeAssessed");
            return this;
        }

        public Builder migrationAsset(MigrationAsset migrationAsset) {
            this.migrationAsset = migrationAsset;
            this.__explicitlySet__.add("migrationAsset");
            return this;
        }

        public Builder preferredShapeType(PreferredShapeType preferredShapeType) {
            this.preferredShapeType = preferredShapeType;
            this.__explicitlySet__.add("preferredShapeType");
            return this;
        }

        public Builder testSpec(LaunchInstanceDetails testSpec) {
            this.testSpec = testSpec;
            this.__explicitlySet__.add("testSpec");
            return this;
        }

        public Builder blockVolumesPerformance(Integer blockVolumesPerformance) {
            this.blockVolumesPerformance = blockVolumesPerformance;
            this.__explicitlySet__.add("blockVolumesPerformance");
            return this;
        }

        public Builder msLicense(String msLicense) {
            this.msLicense = msLicense;
            this.__explicitlySet__.add("msLicense");
            return this;
        }

        public Builder userSpec(LaunchInstanceDetails userSpec) {
            this.userSpec = userSpec;
            this.__explicitlySet__.add("userSpec");
            return this;
        }

        public Builder recommendedSpec(LaunchInstanceDetails recommendedSpec) {
            this.recommendedSpec = recommendedSpec;
            this.__explicitlySet__.add("recommendedSpec");
            return this;
        }

        public VmTargetAsset build() {
            VmTargetAsset model = new VmTargetAsset(this.id, this.displayName, this.lifecycleState, this.lifecycleDetails, this.migrationPlanId, this.compartmentId, this.createdResourceId, this.isExcludedFromExecution, this.compatibilityMessages, this.estimatedCost, this.timeCreated, this.timeUpdated, this.timeAssessed, this.migrationAsset, this.preferredShapeType, this.testSpec, this.blockVolumesPerformance, this.msLicense, this.userSpec, this.recommendedSpec);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(VmTargetAsset model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("migrationPlanId")) {
                this.migrationPlanId(model.getMigrationPlanId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("createdResourceId")) {
                this.createdResourceId(model.getCreatedResourceId());
            }
            if (model.wasPropertyExplicitlySet("isExcludedFromExecution")) {
                this.isExcludedFromExecution(model.getIsExcludedFromExecution());
            }
            if (model.wasPropertyExplicitlySet("compatibilityMessages")) {
                this.compatibilityMessages(model.getCompatibilityMessages());
            }
            if (model.wasPropertyExplicitlySet("estimatedCost")) {
                this.estimatedCost(model.getEstimatedCost());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeAssessed")) {
                this.timeAssessed(model.getTimeAssessed());
            }
            if (model.wasPropertyExplicitlySet("migrationAsset")) {
                this.migrationAsset(model.getMigrationAsset());
            }
            if (model.wasPropertyExplicitlySet("preferredShapeType")) {
                this.preferredShapeType(model.getPreferredShapeType());
            }
            if (model.wasPropertyExplicitlySet("testSpec")) {
                this.testSpec(model.getTestSpec());
            }
            if (model.wasPropertyExplicitlySet("blockVolumesPerformance")) {
                this.blockVolumesPerformance(model.getBlockVolumesPerformance());
            }
            if (model.wasPropertyExplicitlySet("msLicense")) {
                this.msLicense(model.getMsLicense());
            }
            if (model.wasPropertyExplicitlySet("userSpec")) {
                this.userSpec(model.getUserSpec());
            }
            if (model.wasPropertyExplicitlySet("recommendedSpec")) {
                this.recommendedSpec(model.getRecommendedSpec());
            }
            return this;
        }
    }
}

