/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.MetricTimeWindow;
import com.oracle.bmc.cloudmigrations.model.ResourceAssessmentStrategy;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="strategyType")
@JsonFilter(value="explicitlySetFilter")
public final class PercentileResourceAssessmentStrategy
extends ResourceAssessmentStrategy {
    @JsonProperty(value="percentile")
    private final Percentile percentile;
    @JsonProperty(value="adjustmentMultiplier")
    private final Float adjustmentMultiplier;
    @JsonProperty(value="metricTimeWindow")
    private final MetricTimeWindow metricTimeWindow;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PercentileResourceAssessmentStrategy(ResourceAssessmentStrategy.ResourceType resourceType, Percentile percentile, Float adjustmentMultiplier, MetricTimeWindow metricTimeWindow) {
        super(resourceType);
        this.percentile = percentile;
        this.adjustmentMultiplier = adjustmentMultiplier;
        this.metricTimeWindow = metricTimeWindow;
    }

    public Percentile getPercentile() {
        return this.percentile;
    }

    public Float getAdjustmentMultiplier() {
        return this.adjustmentMultiplier;
    }

    public MetricTimeWindow getMetricTimeWindow() {
        return this.metricTimeWindow;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PercentileResourceAssessmentStrategy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", percentile=").append(String.valueOf((Object)this.percentile));
        sb.append(", adjustmentMultiplier=").append(String.valueOf(this.adjustmentMultiplier));
        sb.append(", metricTimeWindow=").append(String.valueOf((Object)this.metricTimeWindow));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PercentileResourceAssessmentStrategy)) {
            return false;
        }
        PercentileResourceAssessmentStrategy other = (PercentileResourceAssessmentStrategy)((Object)o);
        return Objects.equals((Object)this.percentile, (Object)other.percentile) && Objects.equals(this.adjustmentMultiplier, other.adjustmentMultiplier) && Objects.equals((Object)this.metricTimeWindow, (Object)other.metricTimeWindow) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.percentile == null ? 43 : this.percentile.hashCode());
        result = result * 59 + (this.adjustmentMultiplier == null ? 43 : this.adjustmentMultiplier.hashCode());
        result = result * 59 + (this.metricTimeWindow == null ? 43 : this.metricTimeWindow.hashCode());
        return result;
    }

    public static enum Percentile implements BmcEnum
    {
        P50("P50"),
        P90("P90"),
        P95("P95"),
        P99("P99"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Percentile> map;

        private Percentile(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Percentile create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Percentile', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Percentile.class);
            map = new HashMap<String, Percentile>();
            for (Percentile v : Percentile.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private ResourceAssessmentStrategy.ResourceType resourceType;
        @JsonProperty(value="percentile")
        private Percentile percentile;
        @JsonProperty(value="adjustmentMultiplier")
        private Float adjustmentMultiplier;
        @JsonProperty(value="metricTimeWindow")
        private MetricTimeWindow metricTimeWindow;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(ResourceAssessmentStrategy.ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder percentile(Percentile percentile) {
            this.percentile = percentile;
            this.__explicitlySet__.add("percentile");
            return this;
        }

        public Builder adjustmentMultiplier(Float adjustmentMultiplier) {
            this.adjustmentMultiplier = adjustmentMultiplier;
            this.__explicitlySet__.add("adjustmentMultiplier");
            return this;
        }

        public Builder metricTimeWindow(MetricTimeWindow metricTimeWindow) {
            this.metricTimeWindow = metricTimeWindow;
            this.__explicitlySet__.add("metricTimeWindow");
            return this;
        }

        public PercentileResourceAssessmentStrategy build() {
            PercentileResourceAssessmentStrategy model = new PercentileResourceAssessmentStrategy(this.resourceType, this.percentile, this.adjustmentMultiplier, this.metricTimeWindow);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PercentileResourceAssessmentStrategy model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("percentile")) {
                this.percentile(model.getPercentile());
            }
            if (model.wasPropertyExplicitlySet("adjustmentMultiplier")) {
                this.adjustmentMultiplier(model.getAdjustmentMultiplier());
            }
            if (model.wasPropertyExplicitlySet("metricTimeWindow")) {
                this.metricTimeWindow(model.getMetricTimeWindow());
            }
            return this;
        }
    }
}

