/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.CostEstimation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MigrationPlanStats
extends ExplicitlySetBmcModel {
    @JsonProperty(value="totalEstimatedCost")
    private final CostEstimation totalEstimatedCost;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="vmCount")
    private final Integer vmCount;

    @Deprecated
    @ConstructorProperties(value={"totalEstimatedCost", "timeUpdated", "vmCount"})
    public MigrationPlanStats(CostEstimation totalEstimatedCost, Date timeUpdated, Integer vmCount) {
        this.totalEstimatedCost = totalEstimatedCost;
        this.timeUpdated = timeUpdated;
        this.vmCount = vmCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public CostEstimation getTotalEstimatedCost() {
        return this.totalEstimatedCost;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Integer getVmCount() {
        return this.vmCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MigrationPlanStats(");
        sb.append("super=").append(super.toString());
        sb.append("totalEstimatedCost=").append(String.valueOf((Object)this.totalEstimatedCost));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", vmCount=").append(String.valueOf(this.vmCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MigrationPlanStats)) {
            return false;
        }
        MigrationPlanStats other = (MigrationPlanStats)((Object)o);
        return Objects.equals((Object)this.totalEstimatedCost, (Object)other.totalEstimatedCost) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.vmCount, other.vmCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.totalEstimatedCost == null ? 43 : this.totalEstimatedCost.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.vmCount == null ? 43 : this.vmCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="totalEstimatedCost")
        private CostEstimation totalEstimatedCost;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="vmCount")
        private Integer vmCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder totalEstimatedCost(CostEstimation totalEstimatedCost) {
            this.totalEstimatedCost = totalEstimatedCost;
            this.__explicitlySet__.add("totalEstimatedCost");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder vmCount(Integer vmCount) {
            this.vmCount = vmCount;
            this.__explicitlySet__.add("vmCount");
            return this;
        }

        public MigrationPlanStats build() {
            MigrationPlanStats model = new MigrationPlanStats(this.totalEstimatedCost, this.timeUpdated, this.vmCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MigrationPlanStats model) {
            if (model.wasPropertyExplicitlySet("totalEstimatedCost")) {
                this.totalEstimatedCost(model.getTotalEstimatedCost());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("vmCount")) {
                this.vmCount(model.getVmCount());
            }
            return this;
        }
    }
}

