/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudmigrations.model.ResourceAssessmentStrategy;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="strategyType")
@JsonFilter(value="explicitlySetFilter")
public final class AsIsResourceAssessmentStrategy
extends ResourceAssessmentStrategy {
    @JsonProperty(value="adjustmentMultiplier")
    private final Float adjustmentMultiplier;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public AsIsResourceAssessmentStrategy(ResourceAssessmentStrategy.ResourceType resourceType, Float adjustmentMultiplier) {
        super(resourceType);
        this.adjustmentMultiplier = adjustmentMultiplier;
    }

    public Float getAdjustmentMultiplier() {
        return this.adjustmentMultiplier;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AsIsResourceAssessmentStrategy(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", adjustmentMultiplier=").append(String.valueOf(this.adjustmentMultiplier));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsIsResourceAssessmentStrategy)) {
            return false;
        }
        AsIsResourceAssessmentStrategy other = (AsIsResourceAssessmentStrategy)((Object)o);
        return Objects.equals(this.adjustmentMultiplier, other.adjustmentMultiplier) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.adjustmentMultiplier == null ? 43 : this.adjustmentMultiplier.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private ResourceAssessmentStrategy.ResourceType resourceType;
        @JsonProperty(value="adjustmentMultiplier")
        private Float adjustmentMultiplier;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(ResourceAssessmentStrategy.ResourceType resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder adjustmentMultiplier(Float adjustmentMultiplier) {
            this.adjustmentMultiplier = adjustmentMultiplier;
            this.__explicitlySet__.add("adjustmentMultiplier");
            return this;
        }

        public AsIsResourceAssessmentStrategy build() {
            AsIsResourceAssessmentStrategy model = new AsIsResourceAssessmentStrategy(this.resourceType, this.adjustmentMultiplier);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AsIsResourceAssessmentStrategy model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("adjustmentMultiplier")) {
                this.adjustmentMultiplier(model.getAdjustmentMultiplier());
            }
            return this;
        }
    }
}

