/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudmigrations.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.Map;

public enum AccessLevel implements BmcEnum
{
    Accessible("ACCESSIBLE"),
    Restricted("RESTRICTED");

    private final String value;
    private static Map<String, AccessLevel> map;

    private AccessLevel(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    @JsonCreator
    public static AccessLevel create(String key) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        throw new IllegalArgumentException("Invalid AccessLevel: " + key);
    }

    static {
        map = new HashMap<String, AccessLevel>();
        for (AccessLevel v : AccessLevel.values()) {
            map.put(v.getValue(), v);
        }
    }
}

