/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.UpdateProblemStatusDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateProblemStatusRequest
extends BmcRequest<UpdateProblemStatusDetails> {
    private String problemId;
    private UpdateProblemStatusDetails updateProblemStatusDetails;
    private String opcRetryToken;
    private String opcRequestId;
    private String ifMatch;

    public String getProblemId() {
        return this.problemId;
    }

    public UpdateProblemStatusDetails getUpdateProblemStatusDetails() {
        return this.updateProblemStatusDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateProblemStatusDetails getBody$() {
        return this.updateProblemStatusDetails;
    }

    public Builder toBuilder() {
        return new Builder().problemId(this.problemId).updateProblemStatusDetails(this.updateProblemStatusDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",problemId=").append(String.valueOf(this.problemId));
        sb.append(",updateProblemStatusDetails=").append(String.valueOf((Object)this.updateProblemStatusDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateProblemStatusRequest)) {
            return false;
        }
        UpdateProblemStatusRequest other = (UpdateProblemStatusRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.problemId, other.problemId) && Objects.equals((Object)this.updateProblemStatusDetails, (Object)other.updateProblemStatusDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.problemId == null ? 43 : this.problemId.hashCode());
        result = result * 59 + (this.updateProblemStatusDetails == null ? 43 : this.updateProblemStatusDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateProblemStatusRequest, UpdateProblemStatusDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String problemId = null;
        private UpdateProblemStatusDetails updateProblemStatusDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            return this;
        }

        public Builder updateProblemStatusDetails(UpdateProblemStatusDetails updateProblemStatusDetails) {
            this.updateProblemStatusDetails = updateProblemStatusDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateProblemStatusRequest o) {
            this.problemId(o.getProblemId());
            this.updateProblemStatusDetails(o.getUpdateProblemStatusDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateProblemStatusRequest build() {
            UpdateProblemStatusRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateProblemStatusDetails body) {
            this.updateProblemStatusDetails(body);
            return this;
        }

        public UpdateProblemStatusRequest buildWithoutInvocationCallback() {
            UpdateProblemStatusRequest request = new UpdateProblemStatusRequest();
            request.problemId = this.problemId;
            request.updateProblemStatusDetails = this.updateProblemStatusDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

