/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudguard.model.UpdateDataSourceDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDataSourceRequest
extends BmcRequest<UpdateDataSourceDetails> {
    private String dataSourceId;
    private UpdateDataSourceDetails updateDataSourceDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getDataSourceId() {
        return this.dataSourceId;
    }

    public UpdateDataSourceDetails getUpdateDataSourceDetails() {
        return this.updateDataSourceDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateDataSourceDetails getBody$() {
        return this.updateDataSourceDetails;
    }

    public Builder toBuilder() {
        return new Builder().dataSourceId(this.dataSourceId).updateDataSourceDetails(this.updateDataSourceDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataSourceId=").append(String.valueOf(this.dataSourceId));
        sb.append(",updateDataSourceDetails=").append(String.valueOf((Object)this.updateDataSourceDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDataSourceRequest)) {
            return false;
        }
        UpdateDataSourceRequest other = (UpdateDataSourceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataSourceId, other.dataSourceId) && Objects.equals((Object)this.updateDataSourceDetails, (Object)other.updateDataSourceDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataSourceId == null ? 43 : this.dataSourceId.hashCode());
        result = result * 59 + (this.updateDataSourceDetails == null ? 43 : this.updateDataSourceDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDataSourceRequest, UpdateDataSourceDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataSourceId = null;
        private UpdateDataSourceDetails updateDataSourceDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public Builder updateDataSourceDetails(UpdateDataSourceDetails updateDataSourceDetails) {
            this.updateDataSourceDetails = updateDataSourceDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDataSourceRequest o) {
            this.dataSourceId(o.getDataSourceId());
            this.updateDataSourceDetails(o.getUpdateDataSourceDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDataSourceRequest build() {
            UpdateDataSourceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDataSourceDetails body) {
            this.updateDataSourceDetails(body);
            return this;
        }

        public UpdateDataSourceRequest buildWithoutInvocationCallback() {
            UpdateDataSourceRequest request = new UpdateDataSourceRequest();
            request.dataSourceId = this.dataSourceId;
            request.updateDataSourceDetails = this.updateDataSourceDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

