/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudguard.model.ResponderExecutionModes;
import com.oracle.bmc.cloudguard.model.ResponderExecutionStates;
import com.oracle.bmc.cloudguard.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListResponderExecutionsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private List<String> responderRuleIds;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThanOrEqualTo;
    private Date timeCompletedGreaterThanOrEqualTo;
    private Date timeCompletedLessThanOrEqualTo;
    private String targetId;
    private String resourceType;
    private ResponderType responderType;
    private ResponderExecutionStates responderExecutionStatus;
    private ResponderExecutionModes responderExecutionMode;
    private Integer limit;
    private String page;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public List<String> getResponderRuleIds() {
        return this.responderRuleIds;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThanOrEqualTo() {
        return this.timeCreatedLessThanOrEqualTo;
    }

    public Date getTimeCompletedGreaterThanOrEqualTo() {
        return this.timeCompletedGreaterThanOrEqualTo;
    }

    public Date getTimeCompletedLessThanOrEqualTo() {
        return this.timeCompletedLessThanOrEqualTo;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public ResponderType getResponderType() {
        return this.responderType;
    }

    public ResponderExecutionStates getResponderExecutionStatus() {
        return this.responderExecutionStatus;
    }

    public ResponderExecutionModes getResponderExecutionMode() {
        return this.responderExecutionMode;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).responderRuleIds(this.responderRuleIds).timeCreatedGreaterThanOrEqualTo(this.timeCreatedGreaterThanOrEqualTo).timeCreatedLessThanOrEqualTo(this.timeCreatedLessThanOrEqualTo).timeCompletedGreaterThanOrEqualTo(this.timeCompletedGreaterThanOrEqualTo).timeCompletedLessThanOrEqualTo(this.timeCompletedLessThanOrEqualTo).targetId(this.targetId).resourceType(this.resourceType).responderType(this.responderType).responderExecutionStatus(this.responderExecutionStatus).responderExecutionMode(this.responderExecutionMode).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",responderRuleIds=").append(String.valueOf(this.responderRuleIds));
        sb.append(",timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",timeCreatedLessThanOrEqualTo=").append(String.valueOf(this.timeCreatedLessThanOrEqualTo));
        sb.append(",timeCompletedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCompletedGreaterThanOrEqualTo));
        sb.append(",timeCompletedLessThanOrEqualTo=").append(String.valueOf(this.timeCompletedLessThanOrEqualTo));
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",resourceType=").append(String.valueOf(this.resourceType));
        sb.append(",responderType=").append(String.valueOf((Object)this.responderType));
        sb.append(",responderExecutionStatus=").append(String.valueOf((Object)this.responderExecutionStatus));
        sb.append(",responderExecutionMode=").append(String.valueOf((Object)this.responderExecutionMode));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListResponderExecutionsRequest)) {
            return false;
        }
        ListResponderExecutionsRequest other = (ListResponderExecutionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.responderRuleIds, other.responderRuleIds) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals(this.timeCreatedLessThanOrEqualTo, other.timeCreatedLessThanOrEqualTo) && Objects.equals(this.timeCompletedGreaterThanOrEqualTo, other.timeCompletedGreaterThanOrEqualTo) && Objects.equals(this.timeCompletedLessThanOrEqualTo, other.timeCompletedLessThanOrEqualTo) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals((Object)this.responderType, (Object)other.responderType) && Objects.equals((Object)this.responderExecutionStatus, (Object)other.responderExecutionStatus) && Objects.equals((Object)this.responderExecutionMode, (Object)other.responderExecutionMode) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.responderRuleIds == null ? 43 : this.responderRuleIds.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCreatedLessThanOrEqualTo == null ? 43 : this.timeCreatedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCompletedGreaterThanOrEqualTo == null ? 43 : this.timeCompletedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCompletedLessThanOrEqualTo == null ? 43 : this.timeCompletedLessThanOrEqualTo.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.responderType == null ? 43 : this.responderType.hashCode());
        result = result * 59 + (this.responderExecutionStatus == null ? 43 : this.responderExecutionStatus.hashCode());
        result = result * 59 + (this.responderExecutionMode == null ? 43 : this.responderExecutionMode.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListResponderExecutionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private List<String> responderRuleIds = null;
        private Date timeCreatedGreaterThanOrEqualTo = null;
        private Date timeCreatedLessThanOrEqualTo = null;
        private Date timeCompletedGreaterThanOrEqualTo = null;
        private Date timeCompletedLessThanOrEqualTo = null;
        private String targetId = null;
        private String resourceType = null;
        private ResponderType responderType = null;
        private ResponderExecutionStates responderExecutionStatus = null;
        private ResponderExecutionModes responderExecutionMode = null;
        private Integer limit = null;
        private String page = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder responderRuleIds(List<String> responderRuleIds) {
            this.responderRuleIds = responderRuleIds;
            return this;
        }

        public Builder responderRuleIds(String singularValue) {
            return this.responderRuleIds(Arrays.asList(singularValue));
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThanOrEqualTo(Date timeCreatedLessThanOrEqualTo) {
            this.timeCreatedLessThanOrEqualTo = timeCreatedLessThanOrEqualTo;
            return this;
        }

        public Builder timeCompletedGreaterThanOrEqualTo(Date timeCompletedGreaterThanOrEqualTo) {
            this.timeCompletedGreaterThanOrEqualTo = timeCompletedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCompletedLessThanOrEqualTo(Date timeCompletedLessThanOrEqualTo) {
            this.timeCompletedLessThanOrEqualTo = timeCompletedLessThanOrEqualTo;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public Builder responderType(ResponderType responderType) {
            this.responderType = responderType;
            return this;
        }

        public Builder responderExecutionStatus(ResponderExecutionStates responderExecutionStatus) {
            this.responderExecutionStatus = responderExecutionStatus;
            return this;
        }

        public Builder responderExecutionMode(ResponderExecutionModes responderExecutionMode) {
            this.responderExecutionMode = responderExecutionMode;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListResponderExecutionsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.responderRuleIds(o.getResponderRuleIds());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThanOrEqualTo(o.getTimeCreatedLessThanOrEqualTo());
            this.timeCompletedGreaterThanOrEqualTo(o.getTimeCompletedGreaterThanOrEqualTo());
            this.timeCompletedLessThanOrEqualTo(o.getTimeCompletedLessThanOrEqualTo());
            this.targetId(o.getTargetId());
            this.resourceType(o.getResourceType());
            this.responderType(o.getResponderType());
            this.responderExecutionStatus(o.getResponderExecutionStatus());
            this.responderExecutionMode(o.getResponderExecutionMode());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListResponderExecutionsRequest build() {
            ListResponderExecutionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListResponderExecutionsRequest buildWithoutInvocationCallback() {
            ListResponderExecutionsRequest request = new ListResponderExecutionsRequest();
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.responderRuleIds = this.responderRuleIds;
            request.timeCreatedGreaterThanOrEqualTo = this.timeCreatedGreaterThanOrEqualTo;
            request.timeCreatedLessThanOrEqualTo = this.timeCreatedLessThanOrEqualTo;
            request.timeCompletedGreaterThanOrEqualTo = this.timeCompletedGreaterThanOrEqualTo;
            request.timeCompletedLessThanOrEqualTo = this.timeCompletedLessThanOrEqualTo;
            request.targetId = this.targetId;
            request.resourceType = this.resourceType;
            request.responderType = this.responderType;
            request.responderExecutionStatus = this.responderExecutionStatus;
            request.responderExecutionMode = this.responderExecutionMode;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        ResponderRuleName("responderRuleName"),
        ResourceName("resourceName"),
        TimeCompleted("timeCompleted");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ResponderType implements BmcEnum
    {
        Remediation("REMEDIATION"),
        Notification("NOTIFICATION");

        private final String value;
        private static Map<String, ResponderType> map;

        private ResponderType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ResponderType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ResponderType: " + key);
        }

        static {
            map = new HashMap<String, ResponderType>();
            for (ResponderType v : ResponderType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

