/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.Condition;
import com.oracle.bmc.cloudguard.model.ConditionValueType;
import com.oracle.bmc.cloudguard.model.OperatorType;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="kind")
@JsonFilter(value="explicitlySetFilter")
public final class SimpleCondition
extends Condition {
    @JsonProperty(value="parameter")
    private final String parameter;
    @JsonProperty(value="operator")
    private final OperatorType operator;
    @JsonProperty(value="value")
    private final String value;
    @JsonProperty(value="valueType")
    private final ConditionValueType valueType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SimpleCondition(String parameter, OperatorType operator, String value, ConditionValueType valueType) {
        this.parameter = parameter;
        this.operator = operator;
        this.value = value;
        this.valueType = valueType;
    }

    public String getParameter() {
        return this.parameter;
    }

    public OperatorType getOperator() {
        return this.operator;
    }

    public String getValue() {
        return this.value;
    }

    public ConditionValueType getValueType() {
        return this.valueType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SimpleCondition(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", parameter=").append(String.valueOf(this.parameter));
        sb.append(", operator=").append(String.valueOf((Object)this.operator));
        sb.append(", value=").append(String.valueOf(this.value));
        sb.append(", valueType=").append(String.valueOf((Object)this.valueType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleCondition)) {
            return false;
        }
        SimpleCondition other = (SimpleCondition)((Object)o);
        return Objects.equals(this.parameter, other.parameter) && Objects.equals((Object)this.operator, (Object)other.operator) && Objects.equals(this.value, other.value) && Objects.equals((Object)this.valueType, (Object)other.valueType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.parameter == null ? 43 : this.parameter.hashCode());
        result = result * 59 + (this.operator == null ? 43 : this.operator.hashCode());
        result = result * 59 + (this.value == null ? 43 : this.value.hashCode());
        result = result * 59 + (this.valueType == null ? 43 : this.valueType.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="parameter")
        private String parameter;
        @JsonProperty(value="operator")
        private OperatorType operator;
        @JsonProperty(value="value")
        private String value;
        @JsonProperty(value="valueType")
        private ConditionValueType valueType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder parameter(String parameter) {
            this.parameter = parameter;
            this.__explicitlySet__.add("parameter");
            return this;
        }

        public Builder operator(OperatorType operator) {
            this.operator = operator;
            this.__explicitlySet__.add("operator");
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            this.__explicitlySet__.add("value");
            return this;
        }

        public Builder valueType(ConditionValueType valueType) {
            this.valueType = valueType;
            this.__explicitlySet__.add("valueType");
            return this;
        }

        public SimpleCondition build() {
            SimpleCondition model = new SimpleCondition(this.parameter, this.operator, this.value, this.valueType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SimpleCondition model) {
            if (model.wasPropertyExplicitlySet("parameter")) {
                this.parameter(model.getParameter());
            }
            if (model.wasPropertyExplicitlySet("operator")) {
                this.operator(model.getOperator());
            }
            if (model.wasPropertyExplicitlySet("value")) {
                this.value(model.getValue());
            }
            if (model.wasPropertyExplicitlySet("valueType")) {
                this.valueType(model.getValueType());
            }
            return this;
        }
    }
}

