/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ResponderExecutionTrendAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dimensionsMap")
    private final Map<String, String> dimensionsMap;
    @JsonProperty(value="startTimestamp")
    private final BigDecimal startTimestamp;
    @JsonProperty(value="durationInSeconds")
    private final Integer durationInSeconds;
    @JsonProperty(value="count")
    private final Integer count;

    @Deprecated
    @ConstructorProperties(value={"dimensionsMap", "startTimestamp", "durationInSeconds", "count"})
    public ResponderExecutionTrendAggregation(Map<String, String> dimensionsMap, BigDecimal startTimestamp, Integer durationInSeconds, Integer count) {
        this.dimensionsMap = dimensionsMap;
        this.startTimestamp = startTimestamp;
        this.durationInSeconds = durationInSeconds;
        this.count = count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, String> getDimensionsMap() {
        return this.dimensionsMap;
    }

    public BigDecimal getStartTimestamp() {
        return this.startTimestamp;
    }

    public Integer getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public Integer getCount() {
        return this.count;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ResponderExecutionTrendAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("dimensionsMap=").append(String.valueOf(this.dimensionsMap));
        sb.append(", startTimestamp=").append(String.valueOf(this.startTimestamp));
        sb.append(", durationInSeconds=").append(String.valueOf(this.durationInSeconds));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ResponderExecutionTrendAggregation)) {
            return false;
        }
        ResponderExecutionTrendAggregation other = (ResponderExecutionTrendAggregation)((Object)o);
        return Objects.equals(this.dimensionsMap, other.dimensionsMap) && Objects.equals(this.startTimestamp, other.startTimestamp) && Objects.equals(this.durationInSeconds, other.durationInSeconds) && Objects.equals(this.count, other.count) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dimensionsMap == null ? 43 : this.dimensionsMap.hashCode());
        result = result * 59 + (this.startTimestamp == null ? 43 : this.startTimestamp.hashCode());
        result = result * 59 + (this.durationInSeconds == null ? 43 : this.durationInSeconds.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dimensionsMap")
        private Map<String, String> dimensionsMap;
        @JsonProperty(value="startTimestamp")
        private BigDecimal startTimestamp;
        @JsonProperty(value="durationInSeconds")
        private Integer durationInSeconds;
        @JsonProperty(value="count")
        private Integer count;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dimensionsMap(Map<String, String> dimensionsMap) {
            this.dimensionsMap = dimensionsMap;
            this.__explicitlySet__.add("dimensionsMap");
            return this;
        }

        public Builder startTimestamp(BigDecimal startTimestamp) {
            this.startTimestamp = startTimestamp;
            this.__explicitlySet__.add("startTimestamp");
            return this;
        }

        public Builder durationInSeconds(Integer durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            this.__explicitlySet__.add("durationInSeconds");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public ResponderExecutionTrendAggregation build() {
            ResponderExecutionTrendAggregation model = new ResponderExecutionTrendAggregation(this.dimensionsMap, this.startTimestamp, this.durationInSeconds, this.count);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ResponderExecutionTrendAggregation model) {
            if (model.wasPropertyExplicitlySet("dimensionsMap")) {
                this.dimensionsMap(model.getDimensionsMap());
            }
            if (model.wasPropertyExplicitlySet("startTimestamp")) {
                this.startTimestamp(model.getStartTimestamp());
            }
            if (model.wasPropertyExplicitlySet("durationInSeconds")) {
                this.durationInSeconds(model.getDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            return this;
        }
    }
}

