/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ImpactedResourceSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="resourceId")
    private final String resourceId;
    @JsonProperty(value="problemId")
    private final String problemId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="sightingType")
    private final String sightingType;
    @JsonProperty(value="sightingTypeDisplayName")
    private final String sightingTypeDisplayName;
    @JsonProperty(value="resourceName")
    private final String resourceName;
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="region")
    private final String region;
    @JsonProperty(value="timeIdentified")
    private final Date timeIdentified;

    @Deprecated
    @ConstructorProperties(value={"id", "resourceId", "problemId", "compartmentId", "sightingType", "sightingTypeDisplayName", "resourceName", "resourceType", "region", "timeIdentified"})
    public ImpactedResourceSummary(String id, String resourceId, String problemId, String compartmentId, String sightingType, String sightingTypeDisplayName, String resourceName, String resourceType, String region, Date timeIdentified) {
        this.id = id;
        this.resourceId = resourceId;
        this.problemId = problemId;
        this.compartmentId = compartmentId;
        this.sightingType = sightingType;
        this.sightingTypeDisplayName = sightingTypeDisplayName;
        this.resourceName = resourceName;
        this.resourceType = resourceType;
        this.region = region;
        this.timeIdentified = timeIdentified;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getProblemId() {
        return this.problemId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getSightingType() {
        return this.sightingType;
    }

    public String getSightingTypeDisplayName() {
        return this.sightingTypeDisplayName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getRegion() {
        return this.region;
    }

    public Date getTimeIdentified() {
        return this.timeIdentified;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImpactedResourceSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", resourceId=").append(String.valueOf(this.resourceId));
        sb.append(", problemId=").append(String.valueOf(this.problemId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", sightingType=").append(String.valueOf(this.sightingType));
        sb.append(", sightingTypeDisplayName=").append(String.valueOf(this.sightingTypeDisplayName));
        sb.append(", resourceName=").append(String.valueOf(this.resourceName));
        sb.append(", resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", region=").append(String.valueOf(this.region));
        sb.append(", timeIdentified=").append(String.valueOf(this.timeIdentified));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImpactedResourceSummary)) {
            return false;
        }
        ImpactedResourceSummary other = (ImpactedResourceSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.resourceId, other.resourceId) && Objects.equals(this.problemId, other.problemId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.sightingType, other.sightingType) && Objects.equals(this.sightingTypeDisplayName, other.sightingTypeDisplayName) && Objects.equals(this.resourceName, other.resourceName) && Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.region, other.region) && Objects.equals(this.timeIdentified, other.timeIdentified) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.resourceId == null ? 43 : this.resourceId.hashCode());
        result = result * 59 + (this.problemId == null ? 43 : this.problemId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.sightingType == null ? 43 : this.sightingType.hashCode());
        result = result * 59 + (this.sightingTypeDisplayName == null ? 43 : this.sightingTypeDisplayName.hashCode());
        result = result * 59 + (this.resourceName == null ? 43 : this.resourceName.hashCode());
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.region == null ? 43 : this.region.hashCode());
        result = result * 59 + (this.timeIdentified == null ? 43 : this.timeIdentified.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="resourceId")
        private String resourceId;
        @JsonProperty(value="problemId")
        private String problemId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="sightingType")
        private String sightingType;
        @JsonProperty(value="sightingTypeDisplayName")
        private String sightingTypeDisplayName;
        @JsonProperty(value="resourceName")
        private String resourceName;
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="region")
        private String region;
        @JsonProperty(value="timeIdentified")
        private Date timeIdentified;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.__explicitlySet__.add("resourceId");
            return this;
        }

        public Builder problemId(String problemId) {
            this.problemId = problemId;
            this.__explicitlySet__.add("problemId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder sightingType(String sightingType) {
            this.sightingType = sightingType;
            this.__explicitlySet__.add("sightingType");
            return this;
        }

        public Builder sightingTypeDisplayName(String sightingTypeDisplayName) {
            this.sightingTypeDisplayName = sightingTypeDisplayName;
            this.__explicitlySet__.add("sightingTypeDisplayName");
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            this.__explicitlySet__.add("resourceName");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder region(String region) {
            this.region = region;
            this.__explicitlySet__.add("region");
            return this;
        }

        public Builder timeIdentified(Date timeIdentified) {
            this.timeIdentified = timeIdentified;
            this.__explicitlySet__.add("timeIdentified");
            return this;
        }

        public ImpactedResourceSummary build() {
            ImpactedResourceSummary model = new ImpactedResourceSummary(this.id, this.resourceId, this.problemId, this.compartmentId, this.sightingType, this.sightingTypeDisplayName, this.resourceName, this.resourceType, this.region, this.timeIdentified);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImpactedResourceSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("resourceId")) {
                this.resourceId(model.getResourceId());
            }
            if (model.wasPropertyExplicitlySet("problemId")) {
                this.problemId(model.getProblemId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("sightingType")) {
                this.sightingType(model.getSightingType());
            }
            if (model.wasPropertyExplicitlySet("sightingTypeDisplayName")) {
                this.sightingTypeDisplayName(model.getSightingTypeDisplayName());
            }
            if (model.wasPropertyExplicitlySet("resourceName")) {
                this.resourceName(model.getResourceName());
            }
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("region")) {
                this.region(model.getRegion());
            }
            if (model.wasPropertyExplicitlySet("timeIdentified")) {
                this.timeIdentified(model.getTimeIdentified());
            }
            return this;
        }
    }
}

