/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.DataSourceDetails;
import com.oracle.bmc.cloudguard.model.DataSourceFeedProvider;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDataSourceDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dataSourceFeedProvider")
    private final DataSourceFeedProvider dataSourceFeedProvider;
    @JsonProperty(value="dataSourceDetails")
    private final DataSourceDetails dataSourceDetails;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "compartmentId", "dataSourceFeedProvider", "dataSourceDetails", "freeformTags", "definedTags"})
    public CreateDataSourceDetails(String displayName, String compartmentId, DataSourceFeedProvider dataSourceFeedProvider, DataSourceDetails dataSourceDetails, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.dataSourceFeedProvider = dataSourceFeedProvider;
        this.dataSourceDetails = dataSourceDetails;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public DataSourceFeedProvider getDataSourceFeedProvider() {
        return this.dataSourceFeedProvider;
    }

    public DataSourceDetails getDataSourceDetails() {
        return this.dataSourceDetails;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDataSourceDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dataSourceFeedProvider=").append(String.valueOf((Object)this.dataSourceFeedProvider));
        sb.append(", dataSourceDetails=").append(String.valueOf((Object)this.dataSourceDetails));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDataSourceDetails)) {
            return false;
        }
        CreateDataSourceDetails other = (CreateDataSourceDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals((Object)this.dataSourceFeedProvider, (Object)other.dataSourceFeedProvider) && Objects.equals((Object)this.dataSourceDetails, (Object)other.dataSourceDetails) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dataSourceFeedProvider == null ? 43 : this.dataSourceFeedProvider.hashCode());
        result = result * 59 + (this.dataSourceDetails == null ? 43 : this.dataSourceDetails.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dataSourceFeedProvider")
        private DataSourceFeedProvider dataSourceFeedProvider;
        @JsonProperty(value="dataSourceDetails")
        private DataSourceDetails dataSourceDetails;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dataSourceFeedProvider(DataSourceFeedProvider dataSourceFeedProvider) {
            this.dataSourceFeedProvider = dataSourceFeedProvider;
            this.__explicitlySet__.add("dataSourceFeedProvider");
            return this;
        }

        public Builder dataSourceDetails(DataSourceDetails dataSourceDetails) {
            this.dataSourceDetails = dataSourceDetails;
            this.__explicitlySet__.add("dataSourceDetails");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateDataSourceDetails build() {
            CreateDataSourceDetails model = new CreateDataSourceDetails(this.displayName, this.compartmentId, this.dataSourceFeedProvider, this.dataSourceDetails, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDataSourceDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dataSourceFeedProvider")) {
                this.dataSourceFeedProvider(model.getDataSourceFeedProvider());
            }
            if (model.wasPropertyExplicitlySet("dataSourceDetails")) {
                this.dataSourceDetails(model.getDataSourceDetails());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

