/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudguard.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudguard.model.GeographicalLocation;
import com.oracle.bmc.cloudguard.model.PoliticalLocation;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ActivityProblemAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dimensionsMap")
    private final Map<String, String> dimensionsMap;
    @JsonProperty(value="politicalLocation")
    private final PoliticalLocation politicalLocation;
    @JsonProperty(value="geographicalLocation")
    private final GeographicalLocation geographicalLocation;
    @JsonProperty(value="count")
    private final Integer count;

    @Deprecated
    @ConstructorProperties(value={"dimensionsMap", "politicalLocation", "geographicalLocation", "count"})
    public ActivityProblemAggregation(Map<String, String> dimensionsMap, PoliticalLocation politicalLocation, GeographicalLocation geographicalLocation, Integer count) {
        this.dimensionsMap = dimensionsMap;
        this.politicalLocation = politicalLocation;
        this.geographicalLocation = geographicalLocation;
        this.count = count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, String> getDimensionsMap() {
        return this.dimensionsMap;
    }

    public PoliticalLocation getPoliticalLocation() {
        return this.politicalLocation;
    }

    public GeographicalLocation getGeographicalLocation() {
        return this.geographicalLocation;
    }

    public Integer getCount() {
        return this.count;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ActivityProblemAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("dimensionsMap=").append(String.valueOf(this.dimensionsMap));
        sb.append(", politicalLocation=").append(String.valueOf((Object)this.politicalLocation));
        sb.append(", geographicalLocation=").append(String.valueOf((Object)this.geographicalLocation));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityProblemAggregation)) {
            return false;
        }
        ActivityProblemAggregation other = (ActivityProblemAggregation)((Object)o);
        return Objects.equals(this.dimensionsMap, other.dimensionsMap) && Objects.equals((Object)this.politicalLocation, (Object)other.politicalLocation) && Objects.equals((Object)this.geographicalLocation, (Object)other.geographicalLocation) && Objects.equals(this.count, other.count) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dimensionsMap == null ? 43 : this.dimensionsMap.hashCode());
        result = result * 59 + (this.politicalLocation == null ? 43 : this.politicalLocation.hashCode());
        result = result * 59 + (this.geographicalLocation == null ? 43 : this.geographicalLocation.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dimensionsMap")
        private Map<String, String> dimensionsMap;
        @JsonProperty(value="politicalLocation")
        private PoliticalLocation politicalLocation;
        @JsonProperty(value="geographicalLocation")
        private GeographicalLocation geographicalLocation;
        @JsonProperty(value="count")
        private Integer count;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dimensionsMap(Map<String, String> dimensionsMap) {
            this.dimensionsMap = dimensionsMap;
            this.__explicitlySet__.add("dimensionsMap");
            return this;
        }

        public Builder politicalLocation(PoliticalLocation politicalLocation) {
            this.politicalLocation = politicalLocation;
            this.__explicitlySet__.add("politicalLocation");
            return this;
        }

        public Builder geographicalLocation(GeographicalLocation geographicalLocation) {
            this.geographicalLocation = geographicalLocation;
            this.__explicitlySet__.add("geographicalLocation");
            return this;
        }

        public Builder count(Integer count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public ActivityProblemAggregation build() {
            ActivityProblemAggregation model = new ActivityProblemAggregation(this.dimensionsMap, this.politicalLocation, this.geographicalLocation, this.count);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ActivityProblemAggregation model) {
            if (model.wasPropertyExplicitlySet("dimensionsMap")) {
                this.dimensionsMap(model.getDimensionsMap());
            }
            if (model.wasPropertyExplicitlySet("politicalLocation")) {
                this.politicalLocation(model.getPoliticalLocation());
            }
            if (model.wasPropertyExplicitlySet("geographicalLocation")) {
                this.geographicalLocation(model.getGeographicalLocation());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            return this;
        }
    }
}

