/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudbridge.model.UpdateInventoryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateInventoryRequest
extends BmcRequest<UpdateInventoryDetails> {
    private String inventoryId;
    private UpdateInventoryDetails updateInventoryDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getInventoryId() {
        return this.inventoryId;
    }

    public UpdateInventoryDetails getUpdateInventoryDetails() {
        return this.updateInventoryDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateInventoryDetails getBody$() {
        return this.updateInventoryDetails;
    }

    public Builder toBuilder() {
        return new Builder().inventoryId(this.inventoryId).updateInventoryDetails(this.updateInventoryDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",inventoryId=").append(String.valueOf(this.inventoryId));
        sb.append(",updateInventoryDetails=").append(String.valueOf((Object)this.updateInventoryDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateInventoryRequest)) {
            return false;
        }
        UpdateInventoryRequest other = (UpdateInventoryRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.inventoryId, other.inventoryId) && Objects.equals((Object)this.updateInventoryDetails, (Object)other.updateInventoryDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.inventoryId == null ? 43 : this.inventoryId.hashCode());
        result = result * 59 + (this.updateInventoryDetails == null ? 43 : this.updateInventoryDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateInventoryRequest, UpdateInventoryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String inventoryId = null;
        private UpdateInventoryDetails updateInventoryDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public Builder updateInventoryDetails(UpdateInventoryDetails updateInventoryDetails) {
            this.updateInventoryDetails = updateInventoryDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateInventoryRequest o) {
            this.inventoryId(o.getInventoryId());
            this.updateInventoryDetails(o.getUpdateInventoryDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateInventoryRequest build() {
            UpdateInventoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateInventoryDetails body) {
            this.updateInventoryDetails(body);
            return this;
        }

        public UpdateInventoryRequest buildWithoutInvocationCallback() {
            UpdateInventoryRequest request = new UpdateInventoryRequest();
            request.inventoryId = this.inventoryId;
            request.updateInventoryDetails = this.updateInventoryDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

