/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.cloudbridge.model.Asset;
import com.oracle.bmc.cloudbridge.model.AssetType;
import com.oracle.bmc.cloudbridge.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAssetsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private Integer limit;
    private String page;
    private Asset.LifecycleState lifecycleState;
    private String sourceKey;
    private String externalAssetKey;
    private AssetType assetType;
    private String assetId;
    private String displayName;
    private SortOrders sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private String inventoryId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Asset.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getExternalAssetKey() {
        return this.externalAssetKey;
    }

    public AssetType getAssetType() {
        return this.assetType;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sourceKey(this.sourceKey).externalAssetKey(this.externalAssetKey).assetType(this.assetType).assetId(this.assetId).displayName(this.displayName).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).inventoryId(this.inventoryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sourceKey=").append(String.valueOf(this.sourceKey));
        sb.append(",externalAssetKey=").append(String.valueOf(this.externalAssetKey));
        sb.append(",assetType=").append(String.valueOf((Object)this.assetType));
        sb.append(",assetId=").append(String.valueOf(this.assetId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",inventoryId=").append(String.valueOf(this.inventoryId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAssetsRequest)) {
            return false;
        }
        ListAssetsRequest other = (ListAssetsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.sourceKey, other.sourceKey) && Objects.equals(this.externalAssetKey, other.externalAssetKey) && Objects.equals((Object)this.assetType, (Object)other.assetType) && Objects.equals(this.assetId, other.assetId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.inventoryId, other.inventoryId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sourceKey == null ? 43 : this.sourceKey.hashCode());
        result = result * 59 + (this.externalAssetKey == null ? 43 : this.externalAssetKey.hashCode());
        result = result * 59 + (this.assetType == null ? 43 : this.assetType.hashCode());
        result = result * 59 + (this.assetId == null ? 43 : this.assetId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.inventoryId == null ? 43 : this.inventoryId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAssetsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private Integer limit = null;
        private String page = null;
        private Asset.LifecycleState lifecycleState = null;
        private String sourceKey = null;
        private String externalAssetKey = null;
        private AssetType assetType = null;
        private String assetId = null;
        private String displayName = null;
        private SortOrders sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private String inventoryId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(Asset.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
            return this;
        }

        public Builder externalAssetKey(String externalAssetKey) {
            this.externalAssetKey = externalAssetKey;
            return this;
        }

        public Builder assetType(AssetType assetType) {
            this.assetType = assetType;
            return this;
        }

        public Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAssetsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sourceKey(o.getSourceKey());
            this.externalAssetKey(o.getExternalAssetKey());
            this.assetType(o.getAssetType());
            this.assetId(o.getAssetId());
            this.displayName(o.getDisplayName());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.inventoryId(o.getInventoryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAssetsRequest build() {
            ListAssetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAssetsRequest buildWithoutInvocationCallback() {
            ListAssetsRequest request = new ListAssetsRequest();
            request.compartmentId = this.compartmentId;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sourceKey = this.sourceKey;
            request.externalAssetKey = this.externalAssetKey;
            request.assetType = this.assetType;
            request.assetId = this.assetId;
            request.displayName = this.displayName;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.inventoryId = this.inventoryId;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        TimeUpdated("timeUpdated"),
        DisplayName("displayName");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

