/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudbridge.model.ImportInventoryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ImportInventoryRequest
extends BmcRequest<ImportInventoryDetails> {
    private ImportInventoryDetails importInventoryDetails;
    private String inventoryId;
    private String opcRetryToken;
    private String opcRequestId;

    public ImportInventoryDetails getImportInventoryDetails() {
        return this.importInventoryDetails;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public ImportInventoryDetails getBody$() {
        return this.importInventoryDetails;
    }

    public Builder toBuilder() {
        return new Builder().importInventoryDetails(this.importInventoryDetails).inventoryId(this.inventoryId).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",importInventoryDetails=").append(String.valueOf((Object)this.importInventoryDetails));
        sb.append(",inventoryId=").append(String.valueOf(this.inventoryId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportInventoryRequest)) {
            return false;
        }
        ImportInventoryRequest other = (ImportInventoryRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.importInventoryDetails, (Object)other.importInventoryDetails) && Objects.equals(this.inventoryId, other.inventoryId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.importInventoryDetails == null ? 43 : this.importInventoryDetails.hashCode());
        result = result * 59 + (this.inventoryId == null ? 43 : this.inventoryId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ImportInventoryRequest, ImportInventoryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private ImportInventoryDetails importInventoryDetails = null;
        private String inventoryId = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder importInventoryDetails(ImportInventoryDetails importInventoryDetails) {
            this.importInventoryDetails = importInventoryDetails;
            return this;
        }

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ImportInventoryRequest o) {
            this.importInventoryDetails(o.getImportInventoryDetails());
            this.inventoryId(o.getInventoryId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ImportInventoryRequest build() {
            ImportInventoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(ImportInventoryDetails body) {
            this.importInventoryDetails(body);
            return this;
        }

        public ImportInventoryRequest buildWithoutInvocationCallback() {
            ImportInventoryRequest request = new ImportInventoryRequest();
            request.importInventoryDetails = this.importInventoryDetails;
            request.inventoryId = this.inventoryId;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

