/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPluginRequest
extends BmcRequest<Void> {
    private String agentId;
    private String pluginName;
    private String opcRequestId;

    public String getAgentId() {
        return this.agentId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().agentId(this.agentId).pluginName(this.pluginName).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",agentId=").append(String.valueOf(this.agentId));
        sb.append(",pluginName=").append(String.valueOf(this.pluginName));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPluginRequest)) {
            return false;
        }
        GetPluginRequest other = (GetPluginRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.agentId, other.agentId) && Objects.equals(this.pluginName, other.pluginName) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.agentId == null ? 43 : this.agentId.hashCode());
        result = result * 59 + (this.pluginName == null ? 43 : this.pluginName.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPluginRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String agentId = null;
        private String pluginName = null;
        private String opcRequestId = null;

        public Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPluginRequest o) {
            this.agentId(o.getAgentId());
            this.pluginName(o.getPluginName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPluginRequest build() {
            GetPluginRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPluginRequest buildWithoutInvocationCallback() {
            GetPluginRequest request = new GetPluginRequest();
            request.agentId = this.agentId;
            request.pluginName = this.pluginName;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

