/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetEnvironmentRequest
extends BmcRequest<Void> {
    private String environmentId;
    private String opcRequestId;

    public String getEnvironmentId() {
        return this.environmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().environmentId(this.environmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",environmentId=").append(String.valueOf(this.environmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetEnvironmentRequest)) {
            return false;
        }
        GetEnvironmentRequest other = (GetEnvironmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.environmentId, other.environmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.environmentId == null ? 43 : this.environmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetEnvironmentRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String environmentId = null;
        private String opcRequestId = null;

        public Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetEnvironmentRequest o) {
            this.environmentId(o.getEnvironmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetEnvironmentRequest build() {
            GetEnvironmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetEnvironmentRequest buildWithoutInvocationCallback() {
            GetEnvironmentRequest request = new GetEnvironmentRequest();
            request.environmentId = this.environmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

