/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDiscoveryScheduleRequest
extends BmcRequest<Void> {
    private String discoveryScheduleId;
    private String opcRequestId;

    public String getDiscoveryScheduleId() {
        return this.discoveryScheduleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().discoveryScheduleId(this.discoveryScheduleId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",discoveryScheduleId=").append(String.valueOf(this.discoveryScheduleId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDiscoveryScheduleRequest)) {
            return false;
        }
        GetDiscoveryScheduleRequest other = (GetDiscoveryScheduleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.discoveryScheduleId, other.discoveryScheduleId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.discoveryScheduleId == null ? 43 : this.discoveryScheduleId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDiscoveryScheduleRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String discoveryScheduleId = null;
        private String opcRequestId = null;

        public Builder discoveryScheduleId(String discoveryScheduleId) {
            this.discoveryScheduleId = discoveryScheduleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDiscoveryScheduleRequest o) {
            this.discoveryScheduleId(o.getDiscoveryScheduleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDiscoveryScheduleRequest build() {
            GetDiscoveryScheduleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDiscoveryScheduleRequest buildWithoutInvocationCallback() {
            GetDiscoveryScheduleRequest request = new GetDiscoveryScheduleRequest();
            request.discoveryScheduleId = this.discoveryScheduleId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

