/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cloudbridge.model.CreateInventoryDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreateInventoryRequest
extends BmcRequest<CreateInventoryDetails> {
    private CreateInventoryDetails createInventoryDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public CreateInventoryDetails getCreateInventoryDetails() {
        return this.createInventoryDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreateInventoryDetails getBody$() {
        return this.createInventoryDetails;
    }

    public Builder toBuilder() {
        return new Builder().createInventoryDetails(this.createInventoryDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createInventoryDetails=").append(String.valueOf((Object)this.createInventoryDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateInventoryRequest)) {
            return false;
        }
        CreateInventoryRequest other = (CreateInventoryRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createInventoryDetails, (Object)other.createInventoryDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createInventoryDetails == null ? 43 : this.createInventoryDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreateInventoryRequest, CreateInventoryDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreateInventoryDetails createInventoryDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder createInventoryDetails(CreateInventoryDetails createInventoryDetails) {
            this.createInventoryDetails = createInventoryDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreateInventoryRequest o) {
            this.createInventoryDetails(o.getCreateInventoryDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreateInventoryRequest build() {
            CreateInventoryRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreateInventoryDetails body) {
            this.createInventoryDetails(body);
            return this;
        }

        public CreateInventoryRequest buildWithoutInvocationCallback() {
            CreateInventoryRequest request = new CreateInventoryRequest();
            request.createInventoryDetails = this.createInventoryDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

