/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.requests;

import com.oracle.bmc.cloudbridge.model.Asset;
import com.oracle.bmc.cloudbridge.model.AssetType;
import com.oracle.bmc.cloudbridge.model.SortOrders;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AnalyzeAssetsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private List<String> aggregationProperties;
    private Integer limit;
    private String page;
    private Asset.LifecycleState lifecycleState;
    private String sourceKey;
    private String externalAssetKey;
    private AssetType assetType;
    private SortOrders sortOrder;
    private String opcRequestId;
    private List<String> groupBy;
    private String inventoryId;

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<String> getAggregationProperties() {
        return this.aggregationProperties;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public Asset.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public String getExternalAssetKey() {
        return this.externalAssetKey;
    }

    public AssetType getAssetType() {
        return this.assetType;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public String getInventoryId() {
        return this.inventoryId;
    }

    public Builder toBuilder() {
        return new Builder().compartmentId(this.compartmentId).aggregationProperties(this.aggregationProperties).limit(this.limit).page(this.page).lifecycleState(this.lifecycleState).sourceKey(this.sourceKey).externalAssetKey(this.externalAssetKey).assetType(this.assetType).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId).groupBy(this.groupBy).inventoryId(this.inventoryId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",aggregationProperties=").append(String.valueOf(this.aggregationProperties));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",sourceKey=").append(String.valueOf(this.sourceKey));
        sb.append(",externalAssetKey=").append(String.valueOf(this.externalAssetKey));
        sb.append(",assetType=").append(String.valueOf((Object)this.assetType));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",groupBy=").append(String.valueOf(this.groupBy));
        sb.append(",inventoryId=").append(String.valueOf(this.inventoryId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnalyzeAssetsRequest)) {
            return false;
        }
        AnalyzeAssetsRequest other = (AnalyzeAssetsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.aggregationProperties, other.aggregationProperties) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.sourceKey, other.sourceKey) && Objects.equals(this.externalAssetKey, other.externalAssetKey) && Objects.equals((Object)this.assetType, (Object)other.assetType) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.groupBy, other.groupBy) && Objects.equals(this.inventoryId, other.inventoryId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.aggregationProperties == null ? 43 : this.aggregationProperties.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sourceKey == null ? 43 : this.sourceKey.hashCode());
        result = result * 59 + (this.externalAssetKey == null ? 43 : this.externalAssetKey.hashCode());
        result = result * 59 + (this.assetType == null ? 43 : this.assetType.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        result = result * 59 + (this.inventoryId == null ? 43 : this.inventoryId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<AnalyzeAssetsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String compartmentId = null;
        private List<String> aggregationProperties = null;
        private Integer limit = null;
        private String page = null;
        private Asset.LifecycleState lifecycleState = null;
        private String sourceKey = null;
        private String externalAssetKey = null;
        private AssetType assetType = null;
        private SortOrders sortOrder = null;
        private String opcRequestId = null;
        private List<String> groupBy = null;
        private String inventoryId = null;

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder aggregationProperties(List<String> aggregationProperties) {
            this.aggregationProperties = aggregationProperties;
            return this;
        }

        public Builder aggregationProperties(String singularValue) {
            return this.aggregationProperties(Arrays.asList(singularValue));
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(Asset.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder sourceKey(String sourceKey) {
            this.sourceKey = sourceKey;
            return this;
        }

        public Builder externalAssetKey(String externalAssetKey) {
            this.externalAssetKey = externalAssetKey;
            return this;
        }

        public Builder assetType(AssetType assetType) {
            this.assetType = assetType;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder groupBy(List<String> groupBy) {
            this.groupBy = groupBy;
            return this;
        }

        public Builder groupBy(String singularValue) {
            return this.groupBy(Arrays.asList(singularValue));
        }

        public Builder inventoryId(String inventoryId) {
            this.inventoryId = inventoryId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(AnalyzeAssetsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.aggregationProperties(o.getAggregationProperties());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.sourceKey(o.getSourceKey());
            this.externalAssetKey(o.getExternalAssetKey());
            this.assetType(o.getAssetType());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.groupBy(o.getGroupBy());
            this.inventoryId(o.getInventoryId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public AnalyzeAssetsRequest build() {
            AnalyzeAssetsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public AnalyzeAssetsRequest buildWithoutInvocationCallback() {
            AnalyzeAssetsRequest request = new AnalyzeAssetsRequest();
            request.compartmentId = this.compartmentId;
            request.aggregationProperties = this.aggregationProperties;
            request.limit = this.limit;
            request.page = this.page;
            request.lifecycleState = this.lifecycleState;
            request.sourceKey = this.sourceKey;
            request.externalAssetKey = this.externalAssetKey;
            request.assetType = this.assetType;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            request.groupBy = this.groupBy;
            request.inventoryId = this.inventoryId;
            return request;
        }
    }
}

