/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cloudbridge.model.AssetType;
import com.oracle.bmc.cloudbridge.model.ImportInventoryDetails;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="resourceType")
@JsonFilter(value="explicitlySetFilter")
public final class ImportInventoryViaAssetsDetails
extends ImportInventoryDetails {
    @JsonProperty(value="data")
    private final byte[] data;
    @JsonProperty(value="assetType")
    private final AssetType assetType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ImportInventoryViaAssetsDetails(String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, byte[] data, AssetType assetType) {
        super(compartmentId, freeformTags, definedTags);
        this.data = data;
        this.assetType = assetType;
    }

    public byte[] getData() {
        return this.data;
    }

    public AssetType getAssetType() {
        return this.assetType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ImportInventoryViaAssetsDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", data=").append(includeByteArrayContents ? Arrays.toString(this.data) : String.valueOf(this.data) + (this.data != null ? " (byte[" + this.data.length + "])" : ""));
        sb.append(", assetType=").append(String.valueOf((Object)this.assetType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImportInventoryViaAssetsDetails)) {
            return false;
        }
        ImportInventoryViaAssetsDetails other = (ImportInventoryViaAssetsDetails)((Object)o);
        return Arrays.equals(this.data, other.data) && Objects.equals((Object)this.assetType, (Object)other.assetType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.data);
        result = result * 59 + (this.assetType == null ? 43 : this.assetType.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="data")
        private byte[] data;
        @JsonProperty(value="assetType")
        private AssetType assetType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            this.__explicitlySet__.add("data");
            return this;
        }

        public Builder assetType(AssetType assetType) {
            this.assetType = assetType;
            this.__explicitlySet__.add("assetType");
            return this;
        }

        public ImportInventoryViaAssetsDetails build() {
            ImportInventoryViaAssetsDetails model = new ImportInventoryViaAssetsDetails(this.compartmentId, this.freeformTags, this.definedTags, this.data, this.assetType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ImportInventoryViaAssetsDetails model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("data")) {
                this.data(model.getData());
            }
            if (model.wasPropertyExplicitlySet("assetType")) {
                this.assetType(model.getAssetType());
            }
            return this;
        }
    }
}

