/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GpuDevice
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="coresCount")
    private final Integer coresCount;
    @JsonProperty(value="memoryInMBs")
    private final Long memoryInMBs;
    @JsonProperty(value="manufacturer")
    private final String manufacturer;

    @Deprecated
    @ConstructorProperties(value={"name", "description", "coresCount", "memoryInMBs", "manufacturer"})
    public GpuDevice(String name, String description, Integer coresCount, Long memoryInMBs, String manufacturer) {
        this.name = name;
        this.description = description;
        this.coresCount = coresCount;
        this.memoryInMBs = memoryInMBs;
        this.manufacturer = manufacturer;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getCoresCount() {
        return this.coresCount;
    }

    public Long getMemoryInMBs() {
        return this.memoryInMBs;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GpuDevice(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", coresCount=").append(String.valueOf(this.coresCount));
        sb.append(", memoryInMBs=").append(String.valueOf(this.memoryInMBs));
        sb.append(", manufacturer=").append(String.valueOf(this.manufacturer));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GpuDevice)) {
            return false;
        }
        GpuDevice other = (GpuDevice)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.description, other.description) && Objects.equals(this.coresCount, other.coresCount) && Objects.equals(this.memoryInMBs, other.memoryInMBs) && Objects.equals(this.manufacturer, other.manufacturer) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.coresCount == null ? 43 : this.coresCount.hashCode());
        result = result * 59 + (this.memoryInMBs == null ? 43 : this.memoryInMBs.hashCode());
        result = result * 59 + (this.manufacturer == null ? 43 : this.manufacturer.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="coresCount")
        private Integer coresCount;
        @JsonProperty(value="memoryInMBs")
        private Long memoryInMBs;
        @JsonProperty(value="manufacturer")
        private String manufacturer;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder coresCount(Integer coresCount) {
            this.coresCount = coresCount;
            this.__explicitlySet__.add("coresCount");
            return this;
        }

        public Builder memoryInMBs(Long memoryInMBs) {
            this.memoryInMBs = memoryInMBs;
            this.__explicitlySet__.add("memoryInMBs");
            return this;
        }

        public Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            this.__explicitlySet__.add("manufacturer");
            return this;
        }

        public GpuDevice build() {
            GpuDevice model = new GpuDevice(this.name, this.description, this.coresCount, this.memoryInMBs, this.manufacturer);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GpuDevice model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("coresCount")) {
                this.coresCount(model.getCoresCount());
            }
            if (model.wasPropertyExplicitlySet("memoryInMBs")) {
                this.memoryInMBs(model.getMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("manufacturer")) {
                this.manufacturer(model.getManufacturer());
            }
            return this;
        }
    }
}

