/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class Disk
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="bootOrder")
    private final Integer bootOrder;
    @JsonProperty(value="uuid")
    private final String uuid;
    @JsonProperty(value="uuidLun")
    private final String uuidLun;
    @JsonProperty(value="sizeInMBs")
    private final Long sizeInMBs;
    @JsonProperty(value="location")
    private final String location;
    @JsonProperty(value="persistentMode")
    private final String persistentMode;

    @Deprecated
    @ConstructorProperties(value={"name", "bootOrder", "uuid", "uuidLun", "sizeInMBs", "location", "persistentMode"})
    public Disk(String name, Integer bootOrder, String uuid, String uuidLun, Long sizeInMBs, String location, String persistentMode) {
        this.name = name;
        this.bootOrder = bootOrder;
        this.uuid = uuid;
        this.uuidLun = uuidLun;
        this.sizeInMBs = sizeInMBs;
        this.location = location;
        this.persistentMode = persistentMode;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public Integer getBootOrder() {
        return this.bootOrder;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getUuidLun() {
        return this.uuidLun;
    }

    public Long getSizeInMBs() {
        return this.sizeInMBs;
    }

    public String getLocation() {
        return this.location;
    }

    public String getPersistentMode() {
        return this.persistentMode;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("Disk(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", bootOrder=").append(String.valueOf(this.bootOrder));
        sb.append(", uuid=").append(String.valueOf(this.uuid));
        sb.append(", uuidLun=").append(String.valueOf(this.uuidLun));
        sb.append(", sizeInMBs=").append(String.valueOf(this.sizeInMBs));
        sb.append(", location=").append(String.valueOf(this.location));
        sb.append(", persistentMode=").append(String.valueOf(this.persistentMode));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Disk)) {
            return false;
        }
        Disk other = (Disk)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.bootOrder, other.bootOrder) && Objects.equals(this.uuid, other.uuid) && Objects.equals(this.uuidLun, other.uuidLun) && Objects.equals(this.sizeInMBs, other.sizeInMBs) && Objects.equals(this.location, other.location) && Objects.equals(this.persistentMode, other.persistentMode) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.bootOrder == null ? 43 : this.bootOrder.hashCode());
        result = result * 59 + (this.uuid == null ? 43 : this.uuid.hashCode());
        result = result * 59 + (this.uuidLun == null ? 43 : this.uuidLun.hashCode());
        result = result * 59 + (this.sizeInMBs == null ? 43 : this.sizeInMBs.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.persistentMode == null ? 43 : this.persistentMode.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="bootOrder")
        private Integer bootOrder;
        @JsonProperty(value="uuid")
        private String uuid;
        @JsonProperty(value="uuidLun")
        private String uuidLun;
        @JsonProperty(value="sizeInMBs")
        private Long sizeInMBs;
        @JsonProperty(value="location")
        private String location;
        @JsonProperty(value="persistentMode")
        private String persistentMode;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder bootOrder(Integer bootOrder) {
            this.bootOrder = bootOrder;
            this.__explicitlySet__.add("bootOrder");
            return this;
        }

        public Builder uuid(String uuid) {
            this.uuid = uuid;
            this.__explicitlySet__.add("uuid");
            return this;
        }

        public Builder uuidLun(String uuidLun) {
            this.uuidLun = uuidLun;
            this.__explicitlySet__.add("uuidLun");
            return this;
        }

        public Builder sizeInMBs(Long sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            this.__explicitlySet__.add("sizeInMBs");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.__explicitlySet__.add("location");
            return this;
        }

        public Builder persistentMode(String persistentMode) {
            this.persistentMode = persistentMode;
            this.__explicitlySet__.add("persistentMode");
            return this;
        }

        public Disk build() {
            Disk model = new Disk(this.name, this.bootOrder, this.uuid, this.uuidLun, this.sizeInMBs, this.location, this.persistentMode);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(Disk model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("bootOrder")) {
                this.bootOrder(model.getBootOrder());
            }
            if (model.wasPropertyExplicitlySet("uuid")) {
                this.uuid(model.getUuid());
            }
            if (model.wasPropertyExplicitlySet("uuidLun")) {
                this.uuidLun(model.getUuidLun());
            }
            if (model.wasPropertyExplicitlySet("sizeInMBs")) {
                this.sizeInMBs(model.getSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("location")) {
                this.location(model.getLocation());
            }
            if (model.wasPropertyExplicitlySet("persistentMode")) {
                this.persistentMode(model.getPersistentMode());
            }
            return this;
        }
    }
}

