/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AssetAggregation
extends ExplicitlySetBmcModel {
    @JsonProperty(value="dimensions")
    private final Map<String, String> dimensions;
    @JsonProperty(value="count")
    private final Long count;
    @JsonProperty(value="max")
    private final Double max;
    @JsonProperty(value="mean")
    private final Double mean;
    @JsonProperty(value="min")
    private final Double min;
    @JsonProperty(value="sum")
    private final Double sum;
    @JsonProperty(value="aggregatedProperty")
    private final String aggregatedProperty;

    @Deprecated
    @ConstructorProperties(value={"dimensions", "count", "max", "mean", "min", "sum", "aggregatedProperty"})
    public AssetAggregation(Map<String, String> dimensions, Long count, Double max, Double mean, Double min, Double sum, String aggregatedProperty) {
        this.dimensions = dimensions;
        this.count = count;
        this.max = max;
        this.mean = mean;
        this.min = min;
        this.sum = sum;
        this.aggregatedProperty = aggregatedProperty;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Long getCount() {
        return this.count;
    }

    public Double getMax() {
        return this.max;
    }

    public Double getMean() {
        return this.mean;
    }

    public Double getMin() {
        return this.min;
    }

    public Double getSum() {
        return this.sum;
    }

    public String getAggregatedProperty() {
        return this.aggregatedProperty;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AssetAggregation(");
        sb.append("super=").append(super.toString());
        sb.append("dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(", max=").append(String.valueOf(this.max));
        sb.append(", mean=").append(String.valueOf(this.mean));
        sb.append(", min=").append(String.valueOf(this.min));
        sb.append(", sum=").append(String.valueOf(this.sum));
        sb.append(", aggregatedProperty=").append(String.valueOf(this.aggregatedProperty));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AssetAggregation)) {
            return false;
        }
        AssetAggregation other = (AssetAggregation)((Object)o);
        return Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.count, other.count) && Objects.equals(this.max, other.max) && Objects.equals(this.mean, other.mean) && Objects.equals(this.min, other.min) && Objects.equals(this.sum, other.sum) && Objects.equals(this.aggregatedProperty, other.aggregatedProperty) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.max == null ? 43 : this.max.hashCode());
        result = result * 59 + (this.mean == null ? 43 : this.mean.hashCode());
        result = result * 59 + (this.min == null ? 43 : this.min.hashCode());
        result = result * 59 + (this.sum == null ? 43 : this.sum.hashCode());
        result = result * 59 + (this.aggregatedProperty == null ? 43 : this.aggregatedProperty.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="dimensions")
        private Map<String, String> dimensions;
        @JsonProperty(value="count")
        private Long count;
        @JsonProperty(value="max")
        private Double max;
        @JsonProperty(value="mean")
        private Double mean;
        @JsonProperty(value="min")
        private Double min;
        @JsonProperty(value="sum")
        private Double sum;
        @JsonProperty(value="aggregatedProperty")
        private String aggregatedProperty;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder count(Long count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder max(Double max) {
            this.max = max;
            this.__explicitlySet__.add("max");
            return this;
        }

        public Builder mean(Double mean) {
            this.mean = mean;
            this.__explicitlySet__.add("mean");
            return this;
        }

        public Builder min(Double min) {
            this.min = min;
            this.__explicitlySet__.add("min");
            return this;
        }

        public Builder sum(Double sum) {
            this.sum = sum;
            this.__explicitlySet__.add("sum");
            return this;
        }

        public Builder aggregatedProperty(String aggregatedProperty) {
            this.aggregatedProperty = aggregatedProperty;
            this.__explicitlySet__.add("aggregatedProperty");
            return this;
        }

        public AssetAggregation build() {
            AssetAggregation model = new AssetAggregation(this.dimensions, this.count, this.max, this.mean, this.min, this.sum, this.aggregatedProperty);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AssetAggregation model) {
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("max")) {
                this.max(model.getMax());
            }
            if (model.wasPropertyExplicitlySet("mean")) {
                this.mean(model.getMean());
            }
            if (model.wasPropertyExplicitlySet("min")) {
                this.min(model.getMin());
            }
            if (model.wasPropertyExplicitlySet("sum")) {
                this.sum(model.getSum());
            }
            if (model.wasPropertyExplicitlySet("aggregatedProperty")) {
                this.aggregatedProperty(model.getAggregatedProperty());
            }
            return this;
        }
    }
}

