/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.Discovery;
import com.oracle.bmc.cloudbridge.model.AssetSourceLifecycleState;
import com.oracle.bmc.cloudbridge.model.DiscoveryScheduleLifecycleState;
import com.oracle.bmc.cloudbridge.requests.GetAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.GetDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.responses.GetAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.GetDiscoveryScheduleResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DiscoveryWaiters {
    private final ExecutorService executorService;
    private final Discovery client;

    public DiscoveryWaiters(ExecutorService executorService, Discovery client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAssetSourceRequest, GetAssetSourceResponse> forAssetSource(GetAssetSourceRequest request, AssetSourceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAssetSource(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAssetSourceRequest, GetAssetSourceResponse> forAssetSource(GetAssetSourceRequest request, AssetSourceLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAssetSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAssetSourceRequest, GetAssetSourceResponse> forAssetSource(GetAssetSourceRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AssetSourceLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAssetSource(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAssetSourceRequest, GetAssetSourceResponse> forAssetSource(BmcGenericWaiter waiter, GetAssetSourceRequest request, AssetSourceLifecycleState ... targetStates) {
        final HashSet<AssetSourceLifecycleState> targetStatesSet = new HashSet<AssetSourceLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAssetSourceRequest, GetAssetSourceResponse>(){

            @Override
            public GetAssetSourceResponse apply(GetAssetSourceRequest request) {
                return DiscoveryWaiters.this.client.getAssetSource(request);
            }
        }, (Predicate)new Predicate<GetAssetSourceResponse>(){

            @Override
            public boolean test(GetAssetSourceResponse response) {
                return targetStatesSet.contains((Object)response.getAssetSource().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AssetSourceLifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDiscoveryScheduleRequest, GetDiscoveryScheduleResponse> forDiscoverySchedule(GetDiscoveryScheduleRequest request, DiscoveryScheduleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDiscoverySchedule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDiscoveryScheduleRequest, GetDiscoveryScheduleResponse> forDiscoverySchedule(GetDiscoveryScheduleRequest request, DiscoveryScheduleLifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDiscoverySchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDiscoveryScheduleRequest, GetDiscoveryScheduleResponse> forDiscoverySchedule(GetDiscoveryScheduleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, DiscoveryScheduleLifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDiscoverySchedule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDiscoveryScheduleRequest, GetDiscoveryScheduleResponse> forDiscoverySchedule(BmcGenericWaiter waiter, GetDiscoveryScheduleRequest request, DiscoveryScheduleLifecycleState ... targetStates) {
        final HashSet<DiscoveryScheduleLifecycleState> targetStatesSet = new HashSet<DiscoveryScheduleLifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDiscoveryScheduleRequest, GetDiscoveryScheduleResponse>(){

            @Override
            public GetDiscoveryScheduleResponse apply(GetDiscoveryScheduleRequest request) {
                return DiscoveryWaiters.this.client.getDiscoverySchedule(request);
            }
        }, (Predicate)new Predicate<GetDiscoveryScheduleResponse>(){

            @Override
            public boolean test(GetDiscoveryScheduleResponse response) {
                return targetStatesSet.contains((Object)response.getDiscoverySchedule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)DiscoveryScheduleLifecycleState.Deleted)), (Object)request);
    }
}

