/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.cloudbridge.Discovery;
import com.oracle.bmc.cloudbridge.model.AssetSourceConnection;
import com.oracle.bmc.cloudbridge.model.AssetSourceSummary;
import com.oracle.bmc.cloudbridge.model.DiscoveryScheduleSummary;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourceConnectionsRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourcesRequest;
import com.oracle.bmc.cloudbridge.requests.ListDiscoverySchedulesRequest;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourceConnectionsResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourcesResponse;
import com.oracle.bmc.cloudbridge.responses.ListDiscoverySchedulesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DiscoveryPaginators {
    private final Discovery client;

    public DiscoveryPaginators(Discovery client) {
        this.client = client;
    }

    public Iterable<ListAssetSourceConnectionsResponse> listAssetSourceConnectionsResponseIterator(final ListAssetSourceConnectionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAssetSourceConnectionsRequest.Builder>(){

            @Override
            public ListAssetSourceConnectionsRequest.Builder get() {
                return ListAssetSourceConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssetSourceConnectionsResponse, String>(){

            @Override
            public String apply(ListAssetSourceConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssetSourceConnectionsRequest.Builder>, ListAssetSourceConnectionsRequest>(){

            @Override
            public ListAssetSourceConnectionsRequest apply(RequestBuilderAndToken<ListAssetSourceConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssetSourceConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssetSourceConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssetSourceConnectionsRequest, ListAssetSourceConnectionsResponse>(){

            @Override
            public ListAssetSourceConnectionsResponse apply(ListAssetSourceConnectionsRequest request) {
                return DiscoveryPaginators.this.client.listAssetSourceConnections(request);
            }
        });
    }

    public Iterable<AssetSourceConnection> listAssetSourceConnectionsRecordIterator(final ListAssetSourceConnectionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAssetSourceConnectionsRequest.Builder>(){

            @Override
            public ListAssetSourceConnectionsRequest.Builder get() {
                return ListAssetSourceConnectionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssetSourceConnectionsResponse, String>(){

            @Override
            public String apply(ListAssetSourceConnectionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssetSourceConnectionsRequest.Builder>, ListAssetSourceConnectionsRequest>(){

            @Override
            public ListAssetSourceConnectionsRequest apply(RequestBuilderAndToken<ListAssetSourceConnectionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssetSourceConnectionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssetSourceConnectionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssetSourceConnectionsRequest, ListAssetSourceConnectionsResponse>(){

            @Override
            public ListAssetSourceConnectionsResponse apply(ListAssetSourceConnectionsRequest request) {
                return DiscoveryPaginators.this.client.listAssetSourceConnections(request);
            }
        }, (Function)new Function<ListAssetSourceConnectionsResponse, List<AssetSourceConnection>>(){

            @Override
            public List<AssetSourceConnection> apply(ListAssetSourceConnectionsResponse response) {
                return response.getAssetSourceConnectionCollection().getItems();
            }
        });
    }

    public Iterable<ListAssetSourcesResponse> listAssetSourcesResponseIterator(final ListAssetSourcesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAssetSourcesRequest.Builder>(){

            @Override
            public ListAssetSourcesRequest.Builder get() {
                return ListAssetSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssetSourcesResponse, String>(){

            @Override
            public String apply(ListAssetSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssetSourcesRequest.Builder>, ListAssetSourcesRequest>(){

            @Override
            public ListAssetSourcesRequest apply(RequestBuilderAndToken<ListAssetSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssetSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssetSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssetSourcesRequest, ListAssetSourcesResponse>(){

            @Override
            public ListAssetSourcesResponse apply(ListAssetSourcesRequest request) {
                return DiscoveryPaginators.this.client.listAssetSources(request);
            }
        });
    }

    public Iterable<AssetSourceSummary> listAssetSourcesRecordIterator(final ListAssetSourcesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAssetSourcesRequest.Builder>(){

            @Override
            public ListAssetSourcesRequest.Builder get() {
                return ListAssetSourcesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssetSourcesResponse, String>(){

            @Override
            public String apply(ListAssetSourcesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssetSourcesRequest.Builder>, ListAssetSourcesRequest>(){

            @Override
            public ListAssetSourcesRequest apply(RequestBuilderAndToken<ListAssetSourcesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssetSourcesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssetSourcesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssetSourcesRequest, ListAssetSourcesResponse>(){

            @Override
            public ListAssetSourcesResponse apply(ListAssetSourcesRequest request) {
                return DiscoveryPaginators.this.client.listAssetSources(request);
            }
        }, (Function)new Function<ListAssetSourcesResponse, List<AssetSourceSummary>>(){

            @Override
            public List<AssetSourceSummary> apply(ListAssetSourcesResponse response) {
                return response.getAssetSourceCollection().getItems();
            }
        });
    }

    public Iterable<ListDiscoverySchedulesResponse> listDiscoverySchedulesResponseIterator(final ListDiscoverySchedulesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDiscoverySchedulesRequest.Builder>(){

            @Override
            public ListDiscoverySchedulesRequest.Builder get() {
                return ListDiscoverySchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDiscoverySchedulesResponse, String>(){

            @Override
            public String apply(ListDiscoverySchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDiscoverySchedulesRequest.Builder>, ListDiscoverySchedulesRequest>(){

            @Override
            public ListDiscoverySchedulesRequest apply(RequestBuilderAndToken<ListDiscoverySchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDiscoverySchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDiscoverySchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDiscoverySchedulesRequest, ListDiscoverySchedulesResponse>(){

            @Override
            public ListDiscoverySchedulesResponse apply(ListDiscoverySchedulesRequest request) {
                return DiscoveryPaginators.this.client.listDiscoverySchedules(request);
            }
        });
    }

    public Iterable<DiscoveryScheduleSummary> listDiscoverySchedulesRecordIterator(final ListDiscoverySchedulesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDiscoverySchedulesRequest.Builder>(){

            @Override
            public ListDiscoverySchedulesRequest.Builder get() {
                return ListDiscoverySchedulesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDiscoverySchedulesResponse, String>(){

            @Override
            public String apply(ListDiscoverySchedulesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDiscoverySchedulesRequest.Builder>, ListDiscoverySchedulesRequest>(){

            @Override
            public ListDiscoverySchedulesRequest apply(RequestBuilderAndToken<ListDiscoverySchedulesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDiscoverySchedulesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDiscoverySchedulesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDiscoverySchedulesRequest, ListDiscoverySchedulesResponse>(){

            @Override
            public ListDiscoverySchedulesResponse apply(ListDiscoverySchedulesRequest request) {
                return DiscoveryPaginators.this.client.listDiscoverySchedules(request);
            }
        }, (Function)new Function<ListDiscoverySchedulesResponse, List<DiscoveryScheduleSummary>>(){

            @Override
            public List<DiscoveryScheduleSummary> apply(ListDiscoverySchedulesResponse response) {
                return response.getDiscoveryScheduleCollection().getItems();
            }
        });
    }
}

