/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cloudbridge;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cloudbridge.DiscoveryAsync;
import com.oracle.bmc.cloudbridge.model.AssetSource;
import com.oracle.bmc.cloudbridge.model.AssetSourceCollection;
import com.oracle.bmc.cloudbridge.model.AssetSourceConnectionCollection;
import com.oracle.bmc.cloudbridge.model.DiscoverySchedule;
import com.oracle.bmc.cloudbridge.model.DiscoveryScheduleCollection;
import com.oracle.bmc.cloudbridge.requests.ChangeAssetSourceCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.ChangeDiscoveryScheduleCompartmentRequest;
import com.oracle.bmc.cloudbridge.requests.CreateAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.CreateDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.DeleteDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.GetAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.GetDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourceConnectionsRequest;
import com.oracle.bmc.cloudbridge.requests.ListAssetSourcesRequest;
import com.oracle.bmc.cloudbridge.requests.ListDiscoverySchedulesRequest;
import com.oracle.bmc.cloudbridge.requests.RefreshAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateAssetSourceRequest;
import com.oracle.bmc.cloudbridge.requests.UpdateDiscoveryScheduleRequest;
import com.oracle.bmc.cloudbridge.responses.ChangeAssetSourceCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.ChangeDiscoveryScheduleCompartmentResponse;
import com.oracle.bmc.cloudbridge.responses.CreateAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.CreateDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.DeleteDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.GetAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.GetDiscoveryScheduleResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourceConnectionsResponse;
import com.oracle.bmc.cloudbridge.responses.ListAssetSourcesResponse;
import com.oracle.bmc.cloudbridge.responses.ListDiscoverySchedulesResponse;
import com.oracle.bmc.cloudbridge.responses.RefreshAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateAssetSourceResponse;
import com.oracle.bmc.cloudbridge.responses.UpdateDiscoveryScheduleResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveryAsyncClient
extends BaseAsyncClient
implements DiscoveryAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DISCOVERY").serviceEndpointPrefix("").serviceEndpointTemplate("https://cloudbridge.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryAsyncClient.class);

    private DiscoveryAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeAssetSourceCompartmentResponse> changeAssetSourceCompartment(ChangeAssetSourceCompartmentRequest request, AsyncHandler<ChangeAssetSourceCompartmentRequest, ChangeAssetSourceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeAssetSourceCompartmentDetails(), "changeAssetSourceCompartmentDetails is required");
        return this.clientCall(request, ChangeAssetSourceCompartmentResponse::builder).logger(LOG, "changeAssetSourceCompartment").serviceDetails("Discovery", "ChangeAssetSourceCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/ChangeAssetSourceCompartment").method(Method.POST).requestBuilder(ChangeAssetSourceCompartmentRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeAssetSourceCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDiscoveryScheduleCompartmentResponse> changeDiscoveryScheduleCompartment(ChangeDiscoveryScheduleCompartmentRequest request, AsyncHandler<ChangeDiscoveryScheduleCompartmentRequest, ChangeDiscoveryScheduleCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDiscoveryScheduleCompartmentDetails(), "changeDiscoveryScheduleCompartmentDetails is required");
        return this.clientCall(request, ChangeDiscoveryScheduleCompartmentResponse::builder).logger(LOG, "changeDiscoveryScheduleCompartment").serviceDetails("Discovery", "ChangeDiscoveryScheduleCompartment", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/ChangeDiscoveryScheduleCompartment").method(Method.POST).requestBuilder(ChangeDiscoveryScheduleCompartmentRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDiscoveryScheduleCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAssetSourceResponse> createAssetSource(CreateAssetSourceRequest request, AsyncHandler<CreateAssetSourceRequest, CreateAssetSourceResponse> handler) {
        Objects.requireNonNull(request.getCreateAssetSourceDetails(), "createAssetSourceDetails is required");
        return this.clientCall(request, CreateAssetSourceResponse::builder).logger(LOG, "createAssetSource").serviceDetails("Discovery", "CreateAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/CreateAssetSource").method(Method.POST).requestBuilder(CreateAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(AssetSource.class, CreateAssetSourceResponse.Builder::assetSource).handleResponseHeaderString("etag", CreateAssetSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateAssetSourceResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreateAssetSourceResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateDiscoveryScheduleResponse> createDiscoverySchedule(CreateDiscoveryScheduleRequest request, AsyncHandler<CreateDiscoveryScheduleRequest, CreateDiscoveryScheduleResponse> handler) {
        Objects.requireNonNull(request.getCreateDiscoveryScheduleDetails(), "createDiscoveryScheduleDetails is required");
        return this.clientCall(request, CreateDiscoveryScheduleResponse::builder).logger(LOG, "createDiscoverySchedule").serviceDetails("Discovery", "CreateDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/CreateDiscoverySchedule").method(Method.POST).requestBuilder(CreateDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DiscoverySchedule.class, CreateDiscoveryScheduleResponse.Builder::discoverySchedule).handleResponseHeaderString("etag", CreateDiscoveryScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDiscoveryScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAssetSourceResponse> deleteAssetSource(DeleteAssetSourceRequest request, AsyncHandler<DeleteAssetSourceRequest, DeleteAssetSourceResponse> handler) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAssetSourceResponse::builder).logger(LOG, "deleteAssetSource").serviceDetails("Discovery", "DeleteAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/DeleteAssetSource").method(Method.DELETE).requestBuilder(DeleteAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteAssetSourceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDiscoveryScheduleResponse> deleteDiscoverySchedule(DeleteDiscoveryScheduleRequest request, AsyncHandler<DeleteDiscoveryScheduleRequest, DeleteDiscoveryScheduleResponse> handler) {
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDiscoveryScheduleResponse::builder).logger(LOG, "deleteDiscoverySchedule").serviceDetails("Discovery", "DeleteDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/DeleteDiscoverySchedule").method(Method.DELETE).requestBuilder(DeleteDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDiscoveryScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAssetSourceResponse> getAssetSource(GetAssetSourceRequest request, AsyncHandler<GetAssetSourceRequest, GetAssetSourceResponse> handler) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAssetSourceResponse::builder).logger(LOG, "getAssetSource").serviceDetails("Discovery", "GetAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/GetAssetSource").method(Method.GET).requestBuilder(GetAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetSource.class, GetAssetSourceResponse.Builder::assetSource).handleResponseHeaderString("etag", GetAssetSourceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAssetSourceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDiscoveryScheduleResponse> getDiscoverySchedule(GetDiscoveryScheduleRequest request, AsyncHandler<GetDiscoveryScheduleRequest, GetDiscoveryScheduleResponse> handler) {
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDiscoveryScheduleResponse::builder).logger(LOG, "getDiscoverySchedule").serviceDetails("Discovery", "GetDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/GetDiscoverySchedule").method(Method.GET).requestBuilder(GetDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiscoverySchedule.class, GetDiscoveryScheduleResponse.Builder::discoverySchedule).handleResponseHeaderString("etag", GetDiscoveryScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDiscoveryScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAssetSourceConnectionsResponse> listAssetSourceConnections(ListAssetSourceConnectionsRequest request, AsyncHandler<ListAssetSourceConnectionsRequest, ListAssetSourceConnectionsResponse> handler) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAssetSourceConnectionsResponse::builder).logger(LOG, "listAssetSourceConnections").serviceDetails("Discovery", "ListAssetSourceConnections", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/ListAssetSourceConnections").method(Method.POST).requestBuilder(ListAssetSourceConnectionsRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).appendPathParam("actions").appendPathParam("listConnections").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetSourceConnectionCollection.class, ListAssetSourceConnectionsResponse.Builder::assetSourceConnectionCollection).handleResponseHeaderString("opc-request-id", ListAssetSourceConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssetSourceConnectionsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListAssetSourcesResponse> listAssetSources(ListAssetSourcesRequest request, AsyncHandler<ListAssetSourcesRequest, ListAssetSourcesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAssetSourcesResponse::builder).logger(LOG, "listAssetSources").serviceDetails("Discovery", "ListAssetSources", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/ListAssetSources").method(Method.GET).requestBuilder(ListAssetSourcesRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendQueryParam("assetSourceId", (Object)request.getAssetSourceId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AssetSourceCollection.class, ListAssetSourcesResponse.Builder::assetSourceCollection).handleResponseHeaderString("opc-request-id", ListAssetSourcesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAssetSourcesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDiscoverySchedulesResponse> listDiscoverySchedules(ListDiscoverySchedulesRequest request, AsyncHandler<ListDiscoverySchedulesRequest, ListDiscoverySchedulesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDiscoverySchedulesResponse::builder).logger(LOG, "listDiscoverySchedules").serviceDetails("Discovery", "ListDiscoverySchedules", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/ListDiscoverySchedules").method(Method.GET).requestBuilder(ListDiscoverySchedulesRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendQueryParam("discoveryScheduleId", (Object)request.getDiscoveryScheduleId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DiscoveryScheduleCollection.class, ListDiscoverySchedulesResponse.Builder::discoveryScheduleCollection).handleResponseHeaderString("opc-request-id", ListDiscoverySchedulesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDiscoverySchedulesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<RefreshAssetSourceResponse> refreshAssetSource(RefreshAssetSourceRequest request, AsyncHandler<RefreshAssetSourceRequest, RefreshAssetSourceResponse> handler) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RefreshAssetSourceResponse::builder).logger(LOG, "refreshAssetSource").serviceDetails("Discovery", "RefreshAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/RefreshAssetSource").method(Method.POST).requestBuilder(RefreshAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).appendPathParam("actions").appendPathParam("refresh").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", RefreshAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", RefreshAssetSourceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateAssetSourceResponse> updateAssetSource(UpdateAssetSourceRequest request, AsyncHandler<UpdateAssetSourceRequest, UpdateAssetSourceResponse> handler) {
        Validate.notBlank((String)request.getAssetSourceId(), (String)"assetSourceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAssetSourceDetails(), "updateAssetSourceDetails is required");
        return this.clientCall(request, UpdateAssetSourceResponse::builder).logger(LOG, "updateAssetSource").serviceDetails("Discovery", "UpdateAssetSource", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/AssetSource/UpdateAssetSource").method(Method.PUT).requestBuilder(UpdateAssetSourceRequest::builder).basePath("/20220509").appendPathParam("assetSources").appendPathParam(request.getAssetSourceId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateAssetSourceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateAssetSourceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDiscoveryScheduleResponse> updateDiscoverySchedule(UpdateDiscoveryScheduleRequest request, AsyncHandler<UpdateDiscoveryScheduleRequest, UpdateDiscoveryScheduleResponse> handler) {
        Objects.requireNonNull(request.getUpdateDiscoveryScheduleDetails(), "updateDiscoveryScheduleDetails is required");
        Validate.notBlank((String)request.getDiscoveryScheduleId(), (String)"discoveryScheduleId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, UpdateDiscoveryScheduleResponse::builder).logger(LOG, "updateDiscoverySchedule").serviceDetails("Discovery", "UpdateDiscoverySchedule", "https://docs.oracle.com/iaas/api/#/en/OCB/20220509/DiscoverySchedule/UpdateDiscoverySchedule").method(Method.PUT).requestBuilder(UpdateDiscoveryScheduleRequest::builder).basePath("/20220509").appendPathParam("discoverySchedules").appendPathParam(request.getDiscoveryScheduleId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DiscoverySchedule.class, UpdateDiscoveryScheduleResponse.Builder::discoverySchedule).handleResponseHeaderString("etag", UpdateDiscoveryScheduleResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDiscoveryScheduleResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DiscoveryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DiscoveryAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DiscoveryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DiscoveryAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DiscoveryAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DiscoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DiscoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DiscoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DiscoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DiscoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DiscoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DiscoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DiscoveryAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DiscoveryAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DiscoveryAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DiscoveryAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DiscoveryAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

