/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.cims.model.UpdateIncident;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateIncidentRequest
extends BmcRequest<UpdateIncident> {
    private String incidentKey;
    private String csi;
    private UpdateIncident updateIncidentDetails;
    private String ocid;
    private String opcRequestId;
    private String ifMatch;
    private String homeregion;

    public String getIncidentKey() {
        return this.incidentKey;
    }

    public String getCsi() {
        return this.csi;
    }

    public UpdateIncident getUpdateIncidentDetails() {
        return this.updateIncidentDetails;
    }

    public String getOcid() {
        return this.ocid;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    @InternalSdk
    public UpdateIncident getBody$() {
        return this.updateIncidentDetails;
    }

    public Builder toBuilder() {
        return new Builder().incidentKey(this.incidentKey).csi(this.csi).updateIncidentDetails(this.updateIncidentDetails).ocid(this.ocid).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).homeregion(this.homeregion);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",incidentKey=").append(String.valueOf(this.incidentKey));
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",updateIncidentDetails=").append(String.valueOf((Object)this.updateIncidentDetails));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateIncidentRequest)) {
            return false;
        }
        UpdateIncidentRequest other = (UpdateIncidentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.incidentKey, other.incidentKey) && Objects.equals(this.csi, other.csi) && Objects.equals((Object)this.updateIncidentDetails, (Object)other.updateIncidentDetails) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.homeregion, other.homeregion);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.incidentKey == null ? 43 : this.incidentKey.hashCode());
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.updateIncidentDetails == null ? 43 : this.updateIncidentDetails.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateIncidentRequest, UpdateIncident> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String incidentKey = null;
        private String csi = null;
        private UpdateIncident updateIncidentDetails = null;
        private String ocid = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private String homeregion = null;

        public Builder incidentKey(String incidentKey) {
            this.incidentKey = incidentKey;
            return this;
        }

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder updateIncidentDetails(UpdateIncident updateIncidentDetails) {
            this.updateIncidentDetails = updateIncidentDetails;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateIncidentRequest o) {
            this.incidentKey(o.getIncidentKey());
            this.csi(o.getCsi());
            this.updateIncidentDetails(o.getUpdateIncidentDetails());
            this.ocid(o.getOcid());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.homeregion(o.getHomeregion());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateIncidentRequest build() {
            UpdateIncidentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateIncident body) {
            this.updateIncidentDetails(body);
            return this;
        }

        public UpdateIncidentRequest buildWithoutInvocationCallback() {
            UpdateIncidentRequest request = new UpdateIncidentRequest();
            request.incidentKey = this.incidentKey;
            request.csi = this.csi;
            request.updateIncidentDetails = this.updateIncidentDetails;
            request.ocid = this.ocid;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.homeregion = this.homeregion;
            return request;
        }
    }
}

