/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.requests;

import com.oracle.bmc.cims.model.LifecycleState;
import com.oracle.bmc.cims.model.SortBy;
import com.oracle.bmc.cims.model.SortOrder;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListIncidentsRequest
extends BmcRequest<Void> {
    private String csi;
    private String compartmentId;
    private String ocid;
    private Integer limit;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private LifecycleState lifecycleState;
    private String page;
    private String opcRequestId;
    private String homeregion;
    private String problemType;

    public String getCsi() {
        return this.csi;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOcid() {
        return this.ocid;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getHomeregion() {
        return this.homeregion;
    }

    public String getProblemType() {
        return this.problemType;
    }

    public Builder toBuilder() {
        return new Builder().csi(this.csi).compartmentId(this.compartmentId).ocid(this.ocid).limit(this.limit).sortBy(this.sortBy).sortOrder(this.sortOrder).lifecycleState(this.lifecycleState).page(this.page).opcRequestId(this.opcRequestId).homeregion(this.homeregion).problemType(this.problemType);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",csi=").append(String.valueOf(this.csi));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",ocid=").append(String.valueOf(this.ocid));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",homeregion=").append(String.valueOf(this.homeregion));
        sb.append(",problemType=").append(String.valueOf(this.problemType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListIncidentsRequest)) {
            return false;
        }
        ListIncidentsRequest other = (ListIncidentsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.csi, other.csi) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.ocid, other.ocid) && Objects.equals(this.limit, other.limit) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.homeregion, other.homeregion) && Objects.equals(this.problemType, other.problemType);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.csi == null ? 43 : this.csi.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.ocid == null ? 43 : this.ocid.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.homeregion == null ? 43 : this.homeregion.hashCode());
        result = result * 59 + (this.problemType == null ? 43 : this.problemType.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListIncidentsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String csi = null;
        private String compartmentId = null;
        private String ocid = null;
        private Integer limit = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private LifecycleState lifecycleState = null;
        private String page = null;
        private String opcRequestId = null;
        private String homeregion = null;
        private String problemType = null;

        public Builder csi(String csi) {
            this.csi = csi;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder homeregion(String homeregion) {
            this.homeregion = homeregion;
            return this;
        }

        public Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListIncidentsRequest o) {
            this.csi(o.getCsi());
            this.compartmentId(o.getCompartmentId());
            this.ocid(o.getOcid());
            this.limit(o.getLimit());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.lifecycleState(o.getLifecycleState());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.homeregion(o.getHomeregion());
            this.problemType(o.getProblemType());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListIncidentsRequest build() {
            ListIncidentsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListIncidentsRequest buildWithoutInvocationCallback() {
            ListIncidentsRequest request = new ListIncidentsRequest();
            request.csi = this.csi;
            request.compartmentId = this.compartmentId;
            request.ocid = this.ocid;
            request.limit = this.limit;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.lifecycleState = this.lifecycleState;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            request.homeregion = this.homeregion;
            request.problemType = this.problemType;
            return request;
        }
    }
}

