/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.IssueType;
import com.oracle.bmc.cims.model.Scope;
import com.oracle.bmc.cims.model.Unit;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ServiceCategory
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="label")
    private final String label;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="issueTypeList")
    private final List<IssueType> issueTypeList;
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="unit")
    private final Unit unit;
    @JsonProperty(value="limitId")
    private final String limitId;

    @Deprecated
    @ConstructorProperties(value={"key", "name", "label", "description", "issueTypeList", "scope", "unit", "limitId"})
    public ServiceCategory(String key, String name, String label, String description, List<IssueType> issueTypeList, Scope scope, Unit unit, String limitId) {
        this.key = key;
        this.name = name;
        this.label = label;
        this.description = description;
        this.issueTypeList = issueTypeList;
        this.scope = scope;
        this.unit = unit;
        this.limitId = limitId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public List<IssueType> getIssueTypeList() {
        return this.issueTypeList;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String getLimitId() {
        return this.limitId;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ServiceCategory(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", label=").append(String.valueOf(this.label));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", issueTypeList=").append(String.valueOf(this.issueTypeList));
        sb.append(", scope=").append(String.valueOf((Object)this.scope));
        sb.append(", unit=").append(String.valueOf((Object)this.unit));
        sb.append(", limitId=").append(String.valueOf(this.limitId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServiceCategory)) {
            return false;
        }
        ServiceCategory other = (ServiceCategory)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.name, other.name) && Objects.equals(this.label, other.label) && Objects.equals(this.description, other.description) && Objects.equals(this.issueTypeList, other.issueTypeList) && Objects.equals((Object)this.scope, (Object)other.scope) && Objects.equals((Object)this.unit, (Object)other.unit) && Objects.equals(this.limitId, other.limitId) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.label == null ? 43 : this.label.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.issueTypeList == null ? 43 : this.issueTypeList.hashCode());
        result = result * 59 + (this.scope == null ? 43 : this.scope.hashCode());
        result = result * 59 + (this.unit == null ? 43 : this.unit.hashCode());
        result = result * 59 + (this.limitId == null ? 43 : this.limitId.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="label")
        private String label;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="issueTypeList")
        private List<IssueType> issueTypeList;
        @JsonProperty(value="scope")
        private Scope scope;
        @JsonProperty(value="unit")
        private Unit unit;
        @JsonProperty(value="limitId")
        private String limitId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder label(String label) {
            this.label = label;
            this.__explicitlySet__.add("label");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder issueTypeList(List<IssueType> issueTypeList) {
            this.issueTypeList = issueTypeList;
            this.__explicitlySet__.add("issueTypeList");
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder unit(Unit unit) {
            this.unit = unit;
            this.__explicitlySet__.add("unit");
            return this;
        }

        public Builder limitId(String limitId) {
            this.limitId = limitId;
            this.__explicitlySet__.add("limitId");
            return this;
        }

        public ServiceCategory build() {
            ServiceCategory model = new ServiceCategory(this.key, this.name, this.label, this.description, this.issueTypeList, this.scope, this.unit, this.limitId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ServiceCategory model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("label")) {
                this.label(model.getLabel());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("issueTypeList")) {
                this.issueTypeList(model.getIssueTypeList());
            }
            if (model.wasPropertyExplicitlySet("scope")) {
                this.scope(model.getScope());
            }
            if (model.wasPropertyExplicitlySet("unit")) {
                this.unit(model.getUnit());
            }
            if (model.wasPropertyExplicitlySet("limitId")) {
                this.limitId(model.getLimitId());
            }
            return this;
        }
    }
}

