/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.cims.model.Category;
import com.oracle.bmc.cims.model.IssueType;
import com.oracle.bmc.cims.model.Item;
import com.oracle.bmc.cims.model.SubCategory;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ActivityItem
extends Item {
    @JsonProperty(value="comments")
    private final String comments;
    @JsonProperty(value="timeCreated")
    private final Integer timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Integer timeUpdated;
    @JsonProperty(value="activityType")
    private final ActivityType activityType;
    @JsonProperty(value="activityAuthor")
    private final ActivityAuthor activityAuthor;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ActivityItem(String itemKey, String name, Category category, SubCategory subCategory, IssueType issueType, String comments, Integer timeCreated, Integer timeUpdated, ActivityType activityType, ActivityAuthor activityAuthor) {
        super(itemKey, name, category, subCategory, issueType);
        this.comments = comments;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.activityType = activityType;
        this.activityAuthor = activityAuthor;
    }

    public String getComments() {
        return this.comments;
    }

    public Integer getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getTimeUpdated() {
        return this.timeUpdated;
    }

    public ActivityType getActivityType() {
        return this.activityType;
    }

    public ActivityAuthor getActivityAuthor() {
        return this.activityAuthor;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ActivityItem(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", comments=").append(String.valueOf(this.comments));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", activityType=").append(String.valueOf((Object)this.activityType));
        sb.append(", activityAuthor=").append(String.valueOf((Object)this.activityAuthor));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityItem)) {
            return false;
        }
        ActivityItem other = (ActivityItem)((Object)o);
        return Objects.equals(this.comments, other.comments) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.activityType, (Object)other.activityType) && Objects.equals((Object)this.activityAuthor, (Object)other.activityAuthor) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.comments == null ? 43 : this.comments.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.activityType == null ? 43 : this.activityType.hashCode());
        result = result * 59 + (this.activityAuthor == null ? 43 : this.activityAuthor.hashCode());
        return result;
    }

    public static enum ActivityAuthor implements BmcEnum
    {
        Customer("CUSTOMER"),
        Oracle("ORACLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActivityAuthor> map;

        private ActivityAuthor(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActivityAuthor create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActivityAuthor', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActivityAuthor.class);
            map = new HashMap<String, ActivityAuthor>();
            for (ActivityAuthor v : ActivityAuthor.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ActivityType implements BmcEnum
    {
        Notes("NOTES"),
        ProblemDescription("PROBLEM_DESCRIPTION"),
        Update("UPDATE"),
        Close("CLOSE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActivityType> map;

        private ActivityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActivityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActivityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActivityType.class);
            map = new HashMap<String, ActivityType>();
            for (ActivityType v : ActivityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="itemKey")
        private String itemKey;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="category")
        private Category category;
        @JsonProperty(value="subCategory")
        private SubCategory subCategory;
        @JsonProperty(value="issueType")
        private IssueType issueType;
        @JsonProperty(value="comments")
        private String comments;
        @JsonProperty(value="timeCreated")
        private Integer timeCreated;
        @JsonProperty(value="timeUpdated")
        private Integer timeUpdated;
        @JsonProperty(value="activityType")
        private ActivityType activityType;
        @JsonProperty(value="activityAuthor")
        private ActivityAuthor activityAuthor;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder itemKey(String itemKey) {
            this.itemKey = itemKey;
            this.__explicitlySet__.add("itemKey");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder category(Category category) {
            this.category = category;
            this.__explicitlySet__.add("category");
            return this;
        }

        public Builder subCategory(SubCategory subCategory) {
            this.subCategory = subCategory;
            this.__explicitlySet__.add("subCategory");
            return this;
        }

        public Builder issueType(IssueType issueType) {
            this.issueType = issueType;
            this.__explicitlySet__.add("issueType");
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            this.__explicitlySet__.add("comments");
            return this;
        }

        public Builder timeCreated(Integer timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Integer timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder activityType(ActivityType activityType) {
            this.activityType = activityType;
            this.__explicitlySet__.add("activityType");
            return this;
        }

        public Builder activityAuthor(ActivityAuthor activityAuthor) {
            this.activityAuthor = activityAuthor;
            this.__explicitlySet__.add("activityAuthor");
            return this;
        }

        public ActivityItem build() {
            ActivityItem model = new ActivityItem(this.itemKey, this.name, this.category, this.subCategory, this.issueType, this.comments, this.timeCreated, this.timeUpdated, this.activityType, this.activityAuthor);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ActivityItem model) {
            if (model.wasPropertyExplicitlySet("itemKey")) {
                this.itemKey(model.getItemKey());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("category")) {
                this.category(model.getCategory());
            }
            if (model.wasPropertyExplicitlySet("subCategory")) {
                this.subCategory(model.getSubCategory());
            }
            if (model.wasPropertyExplicitlySet("issueType")) {
                this.issueType(model.getIssueType());
            }
            if (model.wasPropertyExplicitlySet("comments")) {
                this.comments(model.getComments());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("activityType")) {
                this.activityType(model.getActivityType());
            }
            if (model.wasPropertyExplicitlySet("activityAuthor")) {
                this.activityAuthor(model.getActivityAuthor());
            }
            return this;
        }
    }
}

