/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.cims;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.cims.IncidentAsync;
import com.oracle.bmc.cims.model.Incident;
import com.oracle.bmc.cims.model.IncidentResourceType;
import com.oracle.bmc.cims.model.IncidentSummary;
import com.oracle.bmc.cims.model.Status;
import com.oracle.bmc.cims.model.ValidationResponse;
import com.oracle.bmc.cims.requests.CreateIncidentRequest;
import com.oracle.bmc.cims.requests.GetIncidentRequest;
import com.oracle.bmc.cims.requests.GetStatusRequest;
import com.oracle.bmc.cims.requests.ListIncidentResourceTypesRequest;
import com.oracle.bmc.cims.requests.ListIncidentsRequest;
import com.oracle.bmc.cims.requests.UpdateIncidentRequest;
import com.oracle.bmc.cims.requests.ValidateUserRequest;
import com.oracle.bmc.cims.responses.CreateIncidentResponse;
import com.oracle.bmc.cims.responses.GetIncidentResponse;
import com.oracle.bmc.cims.responses.GetStatusResponse;
import com.oracle.bmc.cims.responses.ListIncidentResourceTypesResponse;
import com.oracle.bmc.cims.responses.ListIncidentsResponse;
import com.oracle.bmc.cims.responses.UpdateIncidentResponse;
import com.oracle.bmc.cims.responses.ValidateUserResponse;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncidentAsyncClient
extends BaseAsyncClient
implements IncidentAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("INCIDENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://incidentmanagement.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(IncidentAsyncClient.class);

    private IncidentAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateIncidentResponse> createIncident(CreateIncidentRequest request, AsyncHandler<CreateIncidentRequest, CreateIncidentResponse> handler) {
        Objects.requireNonNull(request.getCreateIncidentDetails(), "createIncidentDetails is required");
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, CreateIncidentResponse::builder).logger(LOG, "createIncident").serviceDetails("Incident", "CreateIncident", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/Incident/CreateIncident").method(Method.POST).requestBuilder(CreateIncidentRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).hasBody().handleBody(Incident.class, CreateIncidentResponse.Builder::incident).handleResponseHeaderString("opc-request-id", CreateIncidentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetIncidentResponse> getIncident(GetIncidentRequest request, AsyncHandler<GetIncidentRequest, GetIncidentResponse> handler) {
        Validate.notBlank((String)request.getIncidentKey(), (String)"incidentKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCsi(), "csi is required");
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, GetIncidentResponse::builder).logger(LOG, "getIncident").serviceDetails("Incident", "GetIncident", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/Incident/GetIncident").method(Method.GET).requestBuilder(GetIncidentRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").appendPathParam(request.getIncidentKey()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("csi", request.getCsi()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).appendHeader("problem-type", request.getProblemType()).handleBody(Incident.class, GetIncidentResponse.Builder::incident).handleResponseHeaderString("opc-request-id", GetIncidentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetStatusResponse> getStatus(GetStatusRequest request, AsyncHandler<GetStatusRequest, GetStatusResponse> handler) {
        Validate.notBlank((String)request.getSource(), (String)"source must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, GetStatusResponse::builder).logger(LOG, "getStatus").serviceDetails("Incident", "GetStatus", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/Status/GetStatus").method(Method.GET).requestBuilder(GetStatusRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").appendPathParam("status").appendPathParam(request.getSource()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).handleBody(Status.class, GetStatusResponse.Builder::status).handleResponseHeaderString("opc-request-id", GetStatusResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListIncidentResourceTypesResponse> listIncidentResourceTypes(ListIncidentResourceTypesRequest request, AsyncHandler<ListIncidentResourceTypesRequest, ListIncidentResourceTypesResponse> handler) {
        Objects.requireNonNull(request.getProblemType(), "problemType is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getCsi(), "csi is required");
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, ListIncidentResourceTypesResponse::builder).logger(LOG, "listIncidentResourceTypes").serviceDetails("Incident", "ListIncidentResourceTypes", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/IncidentResourceType/ListIncidentResourceTypes").method(Method.GET).requestBuilder(ListIncidentResourceTypesRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").appendPathParam("incidentResourceTypes").appendQueryParam("problemType", (Object)request.getProblemType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("name", (Object)request.getName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("csi", request.getCsi()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).handleBodyList(IncidentResourceType.class, ListIncidentResourceTypesResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIncidentResourceTypesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIncidentResourceTypesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListIncidentsResponse> listIncidents(ListIncidentsRequest request, AsyncHandler<ListIncidentsRequest, ListIncidentsResponse> handler) {
        Objects.requireNonNull(request.getCsi(), "csi is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, ListIncidentsResponse::builder).logger(LOG, "listIncidents").serviceDetails("Incident", "ListIncidents", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/IncidentSummary/ListIncidents").method(Method.GET).requestBuilder(ListIncidentsRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("problemType", (Object)request.getProblemType()).accept(new String[]{"application/json"}).appendHeader("csi", request.getCsi()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).handleBodyList(IncidentSummary.class, ListIncidentsResponse.Builder::items).handleResponseHeaderString("opc-request-id", ListIncidentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListIncidentsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateIncidentResponse> updateIncident(UpdateIncidentRequest request, AsyncHandler<UpdateIncidentRequest, UpdateIncidentResponse> handler) {
        Validate.notBlank((String)request.getIncidentKey(), (String)"incidentKey must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCsi(), "csi is required");
        Objects.requireNonNull(request.getUpdateIncidentDetails(), "updateIncidentDetails is required");
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, UpdateIncidentResponse::builder).logger(LOG, "updateIncident").serviceDetails("Incident", "UpdateIncident", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/UpdateIncident/UpdateIncident").method(Method.PUT).requestBuilder(UpdateIncidentRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").appendPathParam(request.getIncidentKey()).accept(new String[]{"application/json"}).appendHeader("csi", request.getCsi()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).hasBody().handleBody(Incident.class, UpdateIncidentResponse.Builder::incident).handleResponseHeaderString("opc-request-id", UpdateIncidentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ValidateUserResponse> validateUser(ValidateUserRequest request, AsyncHandler<ValidateUserRequest, ValidateUserResponse> handler) {
        Objects.requireNonNull(request.getCsi(), "csi is required");
        Objects.requireNonNull(request.getOcid(), "ocid is required");
        return this.clientCall(request, ValidateUserResponse::builder).logger(LOG, "validateUser").serviceDetails("Incident", "ValidateUser", "https://docs.oracle.com/iaas/api/#/en/incidentmanagement/20181231/ValidationResponse/ValidateUser").method(Method.GET).requestBuilder(ValidateUserRequest::builder).basePath("/20181231").appendPathParam("v2").appendPathParam("incidents").appendPathParam("user").appendPathParam("validate").appendQueryParam("problemType", (Object)request.getProblemType()).accept(new String[]{"application/json"}).appendHeader("csi", request.getCsi()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("ocid", request.getOcid()).appendHeader("homeregion", request.getHomeregion()).handleBody(ValidationResponse.class, ValidateUserResponse.Builder::validationResponse).handleResponseHeaderString("opc-request-id", ValidateUserResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public IncidentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)IncidentAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IncidentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(IncidentAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IncidentAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)IncidentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)IncidentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)IncidentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)IncidentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public IncidentAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)IncidentAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, IncidentAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public IncidentAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new IncidentAsyncClient((ClientBuilderBase)this, authenticationDetailsProvider);
        }
    }
}

