/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.certificatesmanagement.model.UpdateCaBundleDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateCaBundleRequest
extends BmcRequest<UpdateCaBundleDetails> {
    private String caBundleId;
    private UpdateCaBundleDetails updateCaBundleDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getCaBundleId() {
        return this.caBundleId;
    }

    public UpdateCaBundleDetails getUpdateCaBundleDetails() {
        return this.updateCaBundleDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateCaBundleDetails getBody$() {
        return this.updateCaBundleDetails;
    }

    public Builder toBuilder() {
        return new Builder().caBundleId(this.caBundleId).updateCaBundleDetails(this.updateCaBundleDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",caBundleId=").append(String.valueOf(this.caBundleId));
        sb.append(",updateCaBundleDetails=").append(String.valueOf((Object)this.updateCaBundleDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateCaBundleRequest)) {
            return false;
        }
        UpdateCaBundleRequest other = (UpdateCaBundleRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.caBundleId, other.caBundleId) && Objects.equals((Object)this.updateCaBundleDetails, (Object)other.updateCaBundleDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.caBundleId == null ? 43 : this.caBundleId.hashCode());
        result = result * 59 + (this.updateCaBundleDetails == null ? 43 : this.updateCaBundleDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateCaBundleRequest, UpdateCaBundleDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String caBundleId = null;
        private UpdateCaBundleDetails updateCaBundleDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder caBundleId(String caBundleId) {
            this.caBundleId = caBundleId;
            return this;
        }

        public Builder updateCaBundleDetails(UpdateCaBundleDetails updateCaBundleDetails) {
            this.updateCaBundleDetails = updateCaBundleDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateCaBundleRequest o) {
            this.caBundleId(o.getCaBundleId());
            this.updateCaBundleDetails(o.getUpdateCaBundleDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateCaBundleRequest build() {
            UpdateCaBundleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateCaBundleDetails body) {
            this.updateCaBundleDetails(body);
            return this;
        }

        public UpdateCaBundleRequest buildWithoutInvocationCallback() {
            UpdateCaBundleRequest request = new UpdateCaBundleRequest();
            request.caBundleId = this.caBundleId;
            request.updateCaBundleDetails = this.updateCaBundleDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

