/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCertificateVersionRequest
extends BmcRequest<Void> {
    private String certificateId;
    private Long certificateVersionNumber;
    private String opcRequestId;

    public String getCertificateId() {
        return this.certificateId;
    }

    public Long getCertificateVersionNumber() {
        return this.certificateVersionNumber;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().certificateId(this.certificateId).certificateVersionNumber(this.certificateVersionNumber).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",certificateId=").append(String.valueOf(this.certificateId));
        sb.append(",certificateVersionNumber=").append(String.valueOf(this.certificateVersionNumber));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCertificateVersionRequest)) {
            return false;
        }
        GetCertificateVersionRequest other = (GetCertificateVersionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.certificateId, other.certificateId) && Objects.equals(this.certificateVersionNumber, other.certificateVersionNumber) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateId == null ? 43 : this.certificateId.hashCode());
        result = result * 59 + (this.certificateVersionNumber == null ? 43 : this.certificateVersionNumber.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCertificateVersionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String certificateId = null;
        private Long certificateVersionNumber = null;
        private String opcRequestId = null;

        public Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public Builder certificateVersionNumber(Long certificateVersionNumber) {
            this.certificateVersionNumber = certificateVersionNumber;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCertificateVersionRequest o) {
            this.certificateId(o.getCertificateId());
            this.certificateVersionNumber(o.getCertificateVersionNumber());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCertificateVersionRequest build() {
            GetCertificateVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCertificateVersionRequest buildWithoutInvocationCallback() {
            GetCertificateVersionRequest request = new GetCertificateVersionRequest();
            request.certificateId = this.certificateId;
            request.certificateVersionNumber = this.certificateVersionNumber;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

