/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetCertificateAuthorityVersionRequest
extends BmcRequest<Void> {
    private String certificateAuthorityId;
    private Long certificateAuthorityVersionNumber;
    private String opcRequestId;

    public String getCertificateAuthorityId() {
        return this.certificateAuthorityId;
    }

    public Long getCertificateAuthorityVersionNumber() {
        return this.certificateAuthorityVersionNumber;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().certificateAuthorityId(this.certificateAuthorityId).certificateAuthorityVersionNumber(this.certificateAuthorityVersionNumber).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",certificateAuthorityId=").append(String.valueOf(this.certificateAuthorityId));
        sb.append(",certificateAuthorityVersionNumber=").append(String.valueOf(this.certificateAuthorityVersionNumber));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetCertificateAuthorityVersionRequest)) {
            return false;
        }
        GetCertificateAuthorityVersionRequest other = (GetCertificateAuthorityVersionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.certificateAuthorityId, other.certificateAuthorityId) && Objects.equals(this.certificateAuthorityVersionNumber, other.certificateAuthorityVersionNumber) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certificateAuthorityId == null ? 43 : this.certificateAuthorityId.hashCode());
        result = result * 59 + (this.certificateAuthorityVersionNumber == null ? 43 : this.certificateAuthorityVersionNumber.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetCertificateAuthorityVersionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String certificateAuthorityId = null;
        private Long certificateAuthorityVersionNumber = null;
        private String opcRequestId = null;

        public Builder certificateAuthorityId(String certificateAuthorityId) {
            this.certificateAuthorityId = certificateAuthorityId;
            return this;
        }

        public Builder certificateAuthorityVersionNumber(Long certificateAuthorityVersionNumber) {
            this.certificateAuthorityVersionNumber = certificateAuthorityVersionNumber;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetCertificateAuthorityVersionRequest o) {
            this.certificateAuthorityId(o.getCertificateAuthorityId());
            this.certificateAuthorityVersionNumber(o.getCertificateAuthorityVersionNumber());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetCertificateAuthorityVersionRequest build() {
            GetCertificateAuthorityVersionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetCertificateAuthorityVersionRequest buildWithoutInvocationCallback() {
            GetCertificateAuthorityVersionRequest request = new GetCertificateAuthorityVersionRequest();
            request.certificateAuthorityId = this.certificateAuthorityId;
            request.certificateAuthorityVersionNumber = this.certificateAuthorityVersionNumber;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

