/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificatesmanagement.model.CreateCertificateConfigDetails;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="configType")
@JsonFilter(value="explicitlySetFilter")
public final class CreateCertificateByImportingConfigDetails
extends CreateCertificateConfigDetails {
    @JsonProperty(value="certChainPem")
    private final String certChainPem;
    @JsonProperty(value="privateKeyPem")
    private final String privateKeyPem;
    @JsonProperty(value="certificatePem")
    private final String certificatePem;
    @JsonProperty(value="privateKeyPemPassphrase")
    private final String privateKeyPemPassphrase;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CreateCertificateByImportingConfigDetails(String versionName, String certChainPem, String privateKeyPem, String certificatePem, String privateKeyPemPassphrase) {
        super(versionName);
        this.certChainPem = certChainPem;
        this.privateKeyPem = privateKeyPem;
        this.certificatePem = certificatePem;
        this.privateKeyPemPassphrase = privateKeyPemPassphrase;
    }

    public String getCertChainPem() {
        return this.certChainPem;
    }

    public String getPrivateKeyPem() {
        return this.privateKeyPem;
    }

    public String getCertificatePem() {
        return this.certificatePem;
    }

    public String getPrivateKeyPemPassphrase() {
        return this.privateKeyPemPassphrase;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateCertificateByImportingConfigDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", certChainPem=").append(String.valueOf(this.certChainPem));
        sb.append(", privateKeyPem=").append(String.valueOf(this.privateKeyPem));
        sb.append(", certificatePem=").append(String.valueOf(this.certificatePem));
        sb.append(", privateKeyPemPassphrase=").append(String.valueOf(this.privateKeyPemPassphrase));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateCertificateByImportingConfigDetails)) {
            return false;
        }
        CreateCertificateByImportingConfigDetails other = (CreateCertificateByImportingConfigDetails)((Object)o);
        return Objects.equals(this.certChainPem, other.certChainPem) && Objects.equals(this.privateKeyPem, other.privateKeyPem) && Objects.equals(this.certificatePem, other.certificatePem) && Objects.equals(this.privateKeyPemPassphrase, other.privateKeyPemPassphrase) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.certChainPem == null ? 43 : this.certChainPem.hashCode());
        result = result * 59 + (this.privateKeyPem == null ? 43 : this.privateKeyPem.hashCode());
        result = result * 59 + (this.certificatePem == null ? 43 : this.certificatePem.hashCode());
        result = result * 59 + (this.privateKeyPemPassphrase == null ? 43 : this.privateKeyPemPassphrase.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="versionName")
        private String versionName;
        @JsonProperty(value="certChainPem")
        private String certChainPem;
        @JsonProperty(value="privateKeyPem")
        private String privateKeyPem;
        @JsonProperty(value="certificatePem")
        private String certificatePem;
        @JsonProperty(value="privateKeyPemPassphrase")
        private String privateKeyPemPassphrase;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder versionName(String versionName) {
            this.versionName = versionName;
            this.__explicitlySet__.add("versionName");
            return this;
        }

        public Builder certChainPem(String certChainPem) {
            this.certChainPem = certChainPem;
            this.__explicitlySet__.add("certChainPem");
            return this;
        }

        public Builder privateKeyPem(String privateKeyPem) {
            this.privateKeyPem = privateKeyPem;
            this.__explicitlySet__.add("privateKeyPem");
            return this;
        }

        public Builder certificatePem(String certificatePem) {
            this.certificatePem = certificatePem;
            this.__explicitlySet__.add("certificatePem");
            return this;
        }

        public Builder privateKeyPemPassphrase(String privateKeyPemPassphrase) {
            this.privateKeyPemPassphrase = privateKeyPemPassphrase;
            this.__explicitlySet__.add("privateKeyPemPassphrase");
            return this;
        }

        public CreateCertificateByImportingConfigDetails build() {
            CreateCertificateByImportingConfigDetails model = new CreateCertificateByImportingConfigDetails(this.versionName, this.certChainPem, this.privateKeyPem, this.certificatePem, this.privateKeyPemPassphrase);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateCertificateByImportingConfigDetails model) {
            if (model.wasPropertyExplicitlySet("versionName")) {
                this.versionName(model.getVersionName());
            }
            if (model.wasPropertyExplicitlySet("certChainPem")) {
                this.certChainPem(model.getCertChainPem());
            }
            if (model.wasPropertyExplicitlySet("privateKeyPem")) {
                this.privateKeyPem(model.getPrivateKeyPem());
            }
            if (model.wasPropertyExplicitlySet("certificatePem")) {
                this.certificatePem(model.getCertificatePem());
            }
            if (model.wasPropertyExplicitlySet("privateKeyPemPassphrase")) {
                this.privateKeyPemPassphrase(model.getPrivateKeyPemPassphrase());
            }
            return this;
        }
    }
}

