/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificatesmanagement;

import com.oracle.bmc.certificatesmanagement.CertificatesManagement;
import com.oracle.bmc.certificatesmanagement.model.AssociationSummary;
import com.oracle.bmc.certificatesmanagement.model.CaBundleSummary;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthoritySummary;
import com.oracle.bmc.certificatesmanagement.model.CertificateAuthorityVersionSummary;
import com.oracle.bmc.certificatesmanagement.model.CertificateSummary;
import com.oracle.bmc.certificatesmanagement.model.CertificateVersionSummary;
import com.oracle.bmc.certificatesmanagement.requests.ListAssociationsRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCaBundlesRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificateAuthoritiesRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificateAuthorityVersionsRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificateVersionsRequest;
import com.oracle.bmc.certificatesmanagement.requests.ListCertificatesRequest;
import com.oracle.bmc.certificatesmanagement.responses.ListAssociationsResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCaBundlesResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificateAuthoritiesResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificateAuthorityVersionsResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificateVersionsResponse;
import com.oracle.bmc.certificatesmanagement.responses.ListCertificatesResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class CertificatesManagementPaginators {
    private final CertificatesManagement client;

    public CertificatesManagementPaginators(CertificatesManagement client) {
        this.client = client;
    }

    public Iterable<ListAssociationsResponse> listAssociationsResponseIterator(final ListAssociationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAssociationsRequest.Builder>(){

            @Override
            public ListAssociationsRequest.Builder get() {
                return ListAssociationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssociationsResponse, String>(){

            @Override
            public String apply(ListAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssociationsRequest.Builder>, ListAssociationsRequest>(){

            @Override
            public ListAssociationsRequest apply(RequestBuilderAndToken<ListAssociationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssociationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssociationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssociationsRequest, ListAssociationsResponse>(){

            @Override
            public ListAssociationsResponse apply(ListAssociationsRequest request) {
                return CertificatesManagementPaginators.this.client.listAssociations(request);
            }
        });
    }

    public Iterable<AssociationSummary> listAssociationsRecordIterator(final ListAssociationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAssociationsRequest.Builder>(){

            @Override
            public ListAssociationsRequest.Builder get() {
                return ListAssociationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAssociationsResponse, String>(){

            @Override
            public String apply(ListAssociationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAssociationsRequest.Builder>, ListAssociationsRequest>(){

            @Override
            public ListAssociationsRequest apply(RequestBuilderAndToken<ListAssociationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAssociationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAssociationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAssociationsRequest, ListAssociationsResponse>(){

            @Override
            public ListAssociationsResponse apply(ListAssociationsRequest request) {
                return CertificatesManagementPaginators.this.client.listAssociations(request);
            }
        }, (Function)new Function<ListAssociationsResponse, List<AssociationSummary>>(){

            @Override
            public List<AssociationSummary> apply(ListAssociationsResponse response) {
                return response.getAssociationCollection().getItems();
            }
        });
    }

    public Iterable<ListCaBundlesResponse> listCaBundlesResponseIterator(final ListCaBundlesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCaBundlesRequest.Builder>(){

            @Override
            public ListCaBundlesRequest.Builder get() {
                return ListCaBundlesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCaBundlesResponse, String>(){

            @Override
            public String apply(ListCaBundlesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCaBundlesRequest.Builder>, ListCaBundlesRequest>(){

            @Override
            public ListCaBundlesRequest apply(RequestBuilderAndToken<ListCaBundlesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCaBundlesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCaBundlesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCaBundlesRequest, ListCaBundlesResponse>(){

            @Override
            public ListCaBundlesResponse apply(ListCaBundlesRequest request) {
                return CertificatesManagementPaginators.this.client.listCaBundles(request);
            }
        });
    }

    public Iterable<CaBundleSummary> listCaBundlesRecordIterator(final ListCaBundlesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCaBundlesRequest.Builder>(){

            @Override
            public ListCaBundlesRequest.Builder get() {
                return ListCaBundlesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCaBundlesResponse, String>(){

            @Override
            public String apply(ListCaBundlesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCaBundlesRequest.Builder>, ListCaBundlesRequest>(){

            @Override
            public ListCaBundlesRequest apply(RequestBuilderAndToken<ListCaBundlesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCaBundlesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCaBundlesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCaBundlesRequest, ListCaBundlesResponse>(){

            @Override
            public ListCaBundlesResponse apply(ListCaBundlesRequest request) {
                return CertificatesManagementPaginators.this.client.listCaBundles(request);
            }
        }, (Function)new Function<ListCaBundlesResponse, List<CaBundleSummary>>(){

            @Override
            public List<CaBundleSummary> apply(ListCaBundlesResponse response) {
                return response.getCaBundleCollection().getItems();
            }
        });
    }

    public Iterable<ListCertificateAuthoritiesResponse> listCertificateAuthoritiesResponseIterator(final ListCertificateAuthoritiesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificateAuthoritiesRequest.Builder>(){

            @Override
            public ListCertificateAuthoritiesRequest.Builder get() {
                return ListCertificateAuthoritiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificateAuthoritiesResponse, String>(){

            @Override
            public String apply(ListCertificateAuthoritiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificateAuthoritiesRequest.Builder>, ListCertificateAuthoritiesRequest>(){

            @Override
            public ListCertificateAuthoritiesRequest apply(RequestBuilderAndToken<ListCertificateAuthoritiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificateAuthoritiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificateAuthoritiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse>(){

            @Override
            public ListCertificateAuthoritiesResponse apply(ListCertificateAuthoritiesRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificateAuthorities(request);
            }
        });
    }

    public Iterable<CertificateAuthoritySummary> listCertificateAuthoritiesRecordIterator(final ListCertificateAuthoritiesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificateAuthoritiesRequest.Builder>(){

            @Override
            public ListCertificateAuthoritiesRequest.Builder get() {
                return ListCertificateAuthoritiesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificateAuthoritiesResponse, String>(){

            @Override
            public String apply(ListCertificateAuthoritiesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificateAuthoritiesRequest.Builder>, ListCertificateAuthoritiesRequest>(){

            @Override
            public ListCertificateAuthoritiesRequest apply(RequestBuilderAndToken<ListCertificateAuthoritiesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificateAuthoritiesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificateAuthoritiesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificateAuthoritiesRequest, ListCertificateAuthoritiesResponse>(){

            @Override
            public ListCertificateAuthoritiesResponse apply(ListCertificateAuthoritiesRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificateAuthorities(request);
            }
        }, (Function)new Function<ListCertificateAuthoritiesResponse, List<CertificateAuthoritySummary>>(){

            @Override
            public List<CertificateAuthoritySummary> apply(ListCertificateAuthoritiesResponse response) {
                return response.getCertificateAuthorityCollection().getItems();
            }
        });
    }

    public Iterable<ListCertificateAuthorityVersionsResponse> listCertificateAuthorityVersionsResponseIterator(final ListCertificateAuthorityVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificateAuthorityVersionsRequest.Builder>(){

            @Override
            public ListCertificateAuthorityVersionsRequest.Builder get() {
                return ListCertificateAuthorityVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificateAuthorityVersionsResponse, String>(){

            @Override
            public String apply(ListCertificateAuthorityVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificateAuthorityVersionsRequest.Builder>, ListCertificateAuthorityVersionsRequest>(){

            @Override
            public ListCertificateAuthorityVersionsRequest apply(RequestBuilderAndToken<ListCertificateAuthorityVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificateAuthorityVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificateAuthorityVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificateAuthorityVersionsRequest, ListCertificateAuthorityVersionsResponse>(){

            @Override
            public ListCertificateAuthorityVersionsResponse apply(ListCertificateAuthorityVersionsRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificateAuthorityVersions(request);
            }
        });
    }

    public Iterable<CertificateAuthorityVersionSummary> listCertificateAuthorityVersionsRecordIterator(final ListCertificateAuthorityVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificateAuthorityVersionsRequest.Builder>(){

            @Override
            public ListCertificateAuthorityVersionsRequest.Builder get() {
                return ListCertificateAuthorityVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificateAuthorityVersionsResponse, String>(){

            @Override
            public String apply(ListCertificateAuthorityVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificateAuthorityVersionsRequest.Builder>, ListCertificateAuthorityVersionsRequest>(){

            @Override
            public ListCertificateAuthorityVersionsRequest apply(RequestBuilderAndToken<ListCertificateAuthorityVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificateAuthorityVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificateAuthorityVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificateAuthorityVersionsRequest, ListCertificateAuthorityVersionsResponse>(){

            @Override
            public ListCertificateAuthorityVersionsResponse apply(ListCertificateAuthorityVersionsRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificateAuthorityVersions(request);
            }
        }, (Function)new Function<ListCertificateAuthorityVersionsResponse, List<CertificateAuthorityVersionSummary>>(){

            @Override
            public List<CertificateAuthorityVersionSummary> apply(ListCertificateAuthorityVersionsResponse response) {
                return response.getCertificateAuthorityVersionCollection().getItems();
            }
        });
    }

    public Iterable<ListCertificateVersionsResponse> listCertificateVersionsResponseIterator(final ListCertificateVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificateVersionsRequest.Builder>(){

            @Override
            public ListCertificateVersionsRequest.Builder get() {
                return ListCertificateVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificateVersionsResponse, String>(){

            @Override
            public String apply(ListCertificateVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificateVersionsRequest.Builder>, ListCertificateVersionsRequest>(){

            @Override
            public ListCertificateVersionsRequest apply(RequestBuilderAndToken<ListCertificateVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificateVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificateVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificateVersionsRequest, ListCertificateVersionsResponse>(){

            @Override
            public ListCertificateVersionsResponse apply(ListCertificateVersionsRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificateVersions(request);
            }
        });
    }

    public Iterable<CertificateVersionSummary> listCertificateVersionsRecordIterator(final ListCertificateVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificateVersionsRequest.Builder>(){

            @Override
            public ListCertificateVersionsRequest.Builder get() {
                return ListCertificateVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificateVersionsResponse, String>(){

            @Override
            public String apply(ListCertificateVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificateVersionsRequest.Builder>, ListCertificateVersionsRequest>(){

            @Override
            public ListCertificateVersionsRequest apply(RequestBuilderAndToken<ListCertificateVersionsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificateVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificateVersionsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificateVersionsRequest, ListCertificateVersionsResponse>(){

            @Override
            public ListCertificateVersionsResponse apply(ListCertificateVersionsRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificateVersions(request);
            }
        }, (Function)new Function<ListCertificateVersionsResponse, List<CertificateVersionSummary>>(){

            @Override
            public List<CertificateVersionSummary> apply(ListCertificateVersionsResponse response) {
                return response.getCertificateVersionCollection().getItems();
            }
        });
    }

    public Iterable<ListCertificatesResponse> listCertificatesResponseIterator(final ListCertificatesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            @Override
            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            @Override
            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            @Override
            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            @Override
            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificates(request);
            }
        });
    }

    public Iterable<CertificateSummary> listCertificatesRecordIterator(final ListCertificatesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListCertificatesRequest.Builder>(){

            @Override
            public ListCertificatesRequest.Builder get() {
                return ListCertificatesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListCertificatesResponse, String>(){

            @Override
            public String apply(ListCertificatesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListCertificatesRequest.Builder>, ListCertificatesRequest>(){

            @Override
            public ListCertificatesRequest apply(RequestBuilderAndToken<ListCertificatesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListCertificatesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListCertificatesRequest, ListCertificatesResponse>(){

            @Override
            public ListCertificatesResponse apply(ListCertificatesRequest request) {
                return CertificatesManagementPaginators.this.client.listCertificates(request);
            }
        }, (Function)new Function<ListCertificatesResponse, List<CertificateSummary>>(){

            @Override
            public List<CertificateSummary> apply(ListCertificatesResponse response) {
                return response.getCertificateCollection().getItems();
            }
        });
    }
}

