/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.certificates.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.certificates.model.RevocationReason;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RevocationStatus
extends ExplicitlySetBmcModel {
    @JsonProperty(value="timeRevoked")
    private final Date timeRevoked;
    @JsonProperty(value="revocationReason")
    private final RevocationReason revocationReason;

    @Deprecated
    @ConstructorProperties(value={"timeRevoked", "revocationReason"})
    public RevocationStatus(Date timeRevoked, RevocationReason revocationReason) {
        this.timeRevoked = timeRevoked;
        this.revocationReason = revocationReason;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Date getTimeRevoked() {
        return this.timeRevoked;
    }

    public RevocationReason getRevocationReason() {
        return this.revocationReason;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RevocationStatus(");
        sb.append("super=").append(super.toString());
        sb.append("timeRevoked=").append(String.valueOf(this.timeRevoked));
        sb.append(", revocationReason=").append(String.valueOf((Object)this.revocationReason));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RevocationStatus)) {
            return false;
        }
        RevocationStatus other = (RevocationStatus)((Object)o);
        return Objects.equals(this.timeRevoked, other.timeRevoked) && Objects.equals((Object)this.revocationReason, (Object)other.revocationReason) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.timeRevoked == null ? 43 : this.timeRevoked.hashCode());
        result = result * 59 + (this.revocationReason == null ? 43 : this.revocationReason.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeRevoked")
        private Date timeRevoked;
        @JsonProperty(value="revocationReason")
        private RevocationReason revocationReason;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeRevoked(Date timeRevoked) {
            this.timeRevoked = timeRevoked;
            this.__explicitlySet__.add("timeRevoked");
            return this;
        }

        public Builder revocationReason(RevocationReason revocationReason) {
            this.revocationReason = revocationReason;
            this.__explicitlySet__.add("revocationReason");
            return this;
        }

        public RevocationStatus build() {
            RevocationStatus model = new RevocationStatus(this.timeRevoked, this.revocationReason);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RevocationStatus model) {
            if (model.wasPropertyExplicitlySet("timeRevoked")) {
                this.timeRevoked(model.getTimeRevoked());
            }
            if (model.wasPropertyExplicitlySet("revocationReason")) {
                this.revocationReason(model.getRevocationReason());
            }
            return this;
        }
    }
}

